/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

import org.apache.pluto.om.window.PortletWindow;

import com.univ.portail.core.PortalControlParameter;
import com.univ.portail.core.PortalEnvironment;

// TODO: Auto-generated Javadoc
/**
 * The Class ServletRequestImpl.
 */
public class ServletRequestImpl extends javax.servlet.http.HttpServletRequestWrapper {

	/** The attributes. */
	Map<String, Object> attributes = null;

	/** The control. */
	PortalControlParameter control = null;

	/** The portlet window. */
	PortletWindow portletWindow = null;

	/** The locale. */
	Locale locale = new Locale(Locale.getDefault().getCountry());

	/**
	 * Instantiates a new servlet request impl.
	 * 
	 * @param servletRequest
	 *            the servlet request
	 * @param window
	 *            the window
	 */
	public ServletRequestImpl(final javax.servlet.http.HttpServletRequest servletRequest, final PortletWindow window) {
		super(servletRequest);
		this.portletWindow = window;
		control = new PortalControlParameter(PortalEnvironment.getPortalEnvironment(servletRequest).getRequestedPortalURL());
		attributes = new HashMap<String, Object>();
	}

	/**
	 * Sets the control.
	 * 
	 * @param _control
	 *            the new control
	 */
	public void setControl(final PortalControlParameter _control) {
		control = _control;
	}

	/**
	 * Sets the attribute.
	 * 
	 * @param name
	 *            the name
	 * @param o
	 *            the o
	 * 
	 * @see javax.servlet.ServletRequest#setAttribute(java.lang.String, java.lang.Object)
	 */
	@Override
	public void setAttribute(final String name, final Object o) {
		//super.removeAttribute(name);
		//Log.debug( "ServletRequestImpl "+toString() +" setAttribute " + name + " : "+ o.toString());
		this.attributes.put(name, o);
	}

	/**
	 * Gets the attribute.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @return the attribute
	 * 
	 * @see javax.servlet.ServletRequest#getAttribute(java.lang.String)
	 */
	@Override
	public Object getAttribute(final String name) {
		Object res = null;
		if (this.attributes.containsKey(name)) {
			res = attributes.get(name);
		} else {
			res = super.getAttribute(name);
		}
		//Log.debug( "ServletRequestImpl "+toString() +" getAttribute " + name + " : "+ res);
		return res;
	}

	/**
	 * Gets the attribute names.
	 * 
	 * @return the attribute names
	 * 
	 * @see javax.servlet.ServletRequest#getAttributeNames()
	 */
	@Override
	public Enumeration<String> getAttributeNames() {
		final Vector<String> v = new Vector<String>();
		final Enumeration<String> enumeration = super.getAttributeNames();
		while (enumeration.hasMoreElements()) {
			v.add(enumeration.nextElement());
		}
		v.addAll(attributes.keySet());
		return v.elements();
	}

	/**
	 * Removes the attribute.
	 * 
	 * @param name
	 *            the name
	 * 
	 * @see javax.servlet.ServletRequest#removeAttribute(java.lang.String)
	 */
	@Override
	public void removeAttribute(final String name) {
		this.attributes.remove(name);
		super.getAttribute(name);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletRequestWrapper#getContentType()
	 */
	@Override
	public java.lang.String getContentType() {
		final String contentType = super.getContentType();
		return contentType;
	}

	// ServletRequestWrapper overlay
	/* (non-Javadoc)
	* @see javax.servlet.ServletRequestWrapper#getParameter(java.lang.String)
	*/
	@Override
	public String getParameter(final String name) {
		final String[] values = this.getParameterMap().get(name);
		if (values != null) {
			return values[0];
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletRequestWrapper#getParameterMap()
	 */
	@Override
	public Map<String, String[]> getParameterMap() {
		//get control params
		final Map<String, String[]> portletParameters = new HashMap<String, String[]>();
		final Iterator<String> iterator = control.getRenderParamNames(portletWindow);
		while (iterator.hasNext()) {
			final String name = iterator.next();
			final String[] values = control.getRenderParamValues(portletWindow, name);
			portletParameters.put(name, values);
		}
		//get request params      
		final String pid = control.getPIDValue();
		final String wid = portletWindow.getId().toString();
		if (pid.equals(wid)) {
			for (final Enumeration<String> parameters = super.getParameterNames(); parameters.hasMoreElements();) {
				final String paramName = parameters.nextElement();
				String[] paramValues = super.getParameterValues(paramName);
				final String[] values = portletParameters.get(paramName);
				if (values != null) {
					final String[] temp = new String[paramValues.length + values.length];
					System.arraycopy(paramValues, 0, temp, 0, paramValues.length);
					System.arraycopy(values, 0, temp, paramValues.length, values.length);
					paramValues = temp;
				}
				portletParameters.put(paramName, paramValues);
			}
		}
		return Collections.unmodifiableMap(portletParameters);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletRequestWrapper#getParameterNames()
	 */
	@Override
	public Enumeration<String> getParameterNames() {
		return Collections.enumeration(this.getParameterMap().keySet());
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletRequestWrapper#getParameterValues(java.lang.String)
	 */
	@Override
	public String[] getParameterValues(final String name) {
		return this.getParameterMap().get(name);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletRequestWrapper#getLocale()
	 */
	@Override
	public Locale getLocale() {
		return locale;
	}

	/**
	 * Sets the locale.
	 * 
	 * @param locale
	 *            the new locale
	 */
	public void setLocale(final Locale locale) {
		this.locale = locale;
	}
}
