/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.pluto.om.common.ObjectID;

// TODO: Auto-generated Javadoc
/**
 * * Wraps around the internal Object IDs. By holding both * the string and the integer version of an Object ID this class * helps speed up the internal processing.
 */
public class ObjectIDImpl implements ObjectID, java.io.Serializable {

	/** The string oid. */
	private String stringOID;

	/** The int oid. */
	private int intOID;

	/**
	 * Instantiates a new object id impl.
	 * 
	 * @param oid
	 *            the oid
	 * @param stringOID
	 *            the string oid
	 */
	private ObjectIDImpl(int oid, String stringOID) {
		this.stringOID = stringOID;
		intOID = oid;
	}

	// internal methods.
	/**
	 * Read object.
	 * 
	 * @param stream
	 *            the stream
	 * 
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	private void readObject(ObjectInputStream stream) throws IOException {
		intOID = stream.readInt();
		stringOID = String.valueOf(intOID);
	}

	/**
	 * Write object.
	 * 
	 * @param stream
	 *            the stream
	 * 
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	private void writeObject(ObjectOutputStream stream) throws IOException {
		stream.write(intOID);
	}

	// addtional methods.
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object object) {
		boolean result = false;
		if (object instanceof ObjectIDImpl) {
			result = (intOID == ((ObjectIDImpl) object).intOID);
		} else if (object instanceof String) {
			result = stringOID.equals(object);
		} else if (object instanceof Integer) {
			result = (intOID == ((Integer) object).intValue());
		}
		return (result);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return (intOID);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return (stringOID);
	}

	/**
	 * Int value.
	 * 
	 * @return the int
	 */
	public int intValue() {
		return (intOID);
	}

	/**
	 * Creates the from string.
	 * 
	 * @param idStr
	 *            the id str
	 * 
	 * @return the object id impl
	 */
	static public ObjectIDImpl createFromString(String idStr) {
		char[] id = idStr.toCharArray();
		int _id = 1;
		for (int i = 0; i < id.length; i++) {
			if ((i % 2) == 0) {
				_id *= id[i];
			} else {
				_id ^= id[i];
			}
			_id = Math.abs(_id);
		}
		return new ObjectIDImpl(_id, idStr);
	}
}
