/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceCtrl;
import org.apache.pluto.util.StringUtils;

// TODO: Auto-generated Javadoc
/**
 * The Class PreferenceImpl.
 */
public class PreferenceImpl implements Preference, PreferenceCtrl, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -2625239083705352152L;

	/** The Constant NULL_VALUE. */
	private final static String NULL_VALUE = "#*!0_NULL_0!*#";

	/** The Constant NULL_ARRAYENTRY. */
	private final static String NULL_ARRAYENTRY = "#*!1_NULL_1!*#";

	/** The name. */
	private String name;

	/** The value. */
	private ArrayList<String> value;

	/** The read only. */
	private Boolean readOnly;

	/**
	 * Instantiates a new preference impl.
	 */
	public PreferenceImpl() {}

	// Preference implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.Preference#getName()
	 */
	@Override
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.Preference#getValues()
	 */
	@Override
	public Iterator<String> getValues() {
		// replace the NULL_VALUE String by NULL
		if (value.contains(NULL_VALUE)) {
			return null;
		}
		final ArrayList<String> returnValue = new ArrayList<String>(value.size());
		returnValue.addAll(value);
		// replace all NULL_ARRAYENTRY Strings by NULL
		for (int i = 0; i < returnValue.size(); i++) {
			if (NULL_ARRAYENTRY.equals(returnValue.get(i))) {
				returnValue.set(i, null);
			}
		}
		return returnValue.iterator();
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.Preference#isReadOnly()
	 */
	@Override
	public boolean isReadOnly() {
		if (readOnly == null) {
			return false;
		}
		return readOnly.booleanValue();
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.Preference#isValueSet()
	 */
	@Override
	public boolean isValueSet() {
		return value != null;
	}

	// PreferenceCtrl implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceCtrl#setName(java.lang.String)
	 */
	@Override
	public void setName(final String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceCtrl#setValues(java.util.List)
	 */
	@Override
	public void setValues(final List _value) {
		if (this.value == null) {
			this.value = new ArrayList<String>();
		} else {
			this.value.clear();
		}
		List<String> addValue = null;
		// replace NULL by the NULL_VALUE String
		if (_value == null) {
			addValue = new ArrayList<String>(1);
			addValue.add(NULL_VALUE);
		} else {
			// replace all NULL by the NULL_ARRAYENTRY String
			addValue = new ArrayList<>(_value.size());
			addValue.addAll(_value);
			for (int i = 0; i < addValue.size(); i++) {
				if (addValue.get(i) == null) {
					addValue.set(i, NULL_ARRAYENTRY);
				}
			}
		}
		this.value.addAll(addValue);
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceCtrl#setReadOnly(java.lang.String)
	 */
	@Override
	public void setReadOnly(final String readOnly) {
		this.readOnly = new Boolean(readOnly);
	}

	// additional methods.
	// internal methods only used by castor
	/**
	 * Gets the read only.
	 *
	 * @return the read only
	 */
	public String getReadOnly() {
		if (readOnly == null) {
			return Boolean.FALSE.toString();
		}
		return readOnly.toString();
	}

	/**
	 * Gets the castor values.
	 *
	 * @return the castor values
	 */
	public Collection<String> getCastorValues() {
		return value;
	}

	/**
	 * Sets the castor values.
	 *
	 * @param _value
	 *            the new castor values
	 */
	public void setCastorValues(final Collection<String> _value) {
		if (value == null) {
			value = new ArrayList<String>();
		} else {
			value.clear();
		}
		value.addAll(_value);
	}

	/**
	 * Gets the cloned castor values as list.
	 *
	 * @return the cloned castor values as list
	 */
	protected List<String> getClonedCastorValuesAsList() {
		final List<String> returnValue = new ArrayList<String>(value.size());
		final Iterator<String> iter = value.iterator();
		while (iter.hasNext()) {
			final String value = iter.next();
			returnValue.add(value);
		}
		return returnValue;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": name='");
		buffer.append(name);
		buffer.append("', value='");
		if (value == null) {
			buffer.append("null");
		} else {
			StringUtils.newLine(buffer, indent);
			buffer.append("{");
			final Iterator<String> iterator = value.iterator();
			if (iterator.hasNext()) {
				StringUtils.newLine(buffer, indent);
				buffer.append(iterator.next());
			}
			while (iterator.hasNext()) {
				StringUtils.indent(buffer, indent + 2);
				buffer.append(iterator.next());
			}
			StringUtils.newLine(buffer, indent);
			buffer.append("}");
		}
		buffer.append("', isReadOnly='");
		buffer.append(isReadOnly());
		buffer.append("'");
		return buffer.toString();
	}

	/**
	 * Adds the user values.
	 *
	 * @param liste
	 *            the liste
	 */
	public void addUserValues(final List<String> liste) {
		if (this.value == null) {
			this.value = new ArrayList<String>();
		}
		// replace NULL by the NULL_VALUE String
		if (liste == null) {
			if (!value.contains(NULL_VALUE)) {
				value.add(NULL_VALUE);
			}
		} else {
			// replace all NULL by the NULL_ARRAYENTRY String
			for (int i = 0; i < liste.size(); i++) {
				if (liste.get(i) == null) {
					if (!value.contains(NULL_VALUE)) {
						value.add(NULL_ARRAYENTRY);
					}
				} else {
					if (!value.contains(liste.get(i))) {
						value.add(liste.get(i));
					}
				}
			}
		}
	}
}
