/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import javax.portlet.PreferencesValidator;

import org.apache.pluto.om.common.Preference;
import org.apache.pluto.om.common.PreferenceSet;
import org.apache.pluto.om.common.PreferenceSetCtrl;
import org.apache.pluto.util.StringUtils;
import org.slf4j.LoggerFactory;

// TODO: Auto-generated Javadoc
/**
 * The Class PreferenceSetImpl.
 */
public class PreferenceSetImpl extends HashSet implements PreferenceSet, PreferenceSetCtrl, java.io.Serializable {

	/**
	 *
	 */
	private static final long serialVersionUID = -6556013026178698811L;

	/** The castor preferences validator. */
	private String castorPreferencesValidator;

	/** The class loader. */
	private ClassLoader classLoader;

	/** The validator instance. */
	private PreferencesValidator validatorInstance = null;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(PreferenceSetImpl.class);

	/**
	 * Instantiates a new preference set impl.
	 */
	public PreferenceSetImpl() {}

	// PreferenceSet implementation.
	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceSet#get(java.lang.String)
	 */
	@Override
	public Preference get(final String name) {
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			final Preference preference = (Preference) iterator.next();
			if (preference.getName().equals(name)) {
				return preference;
			}
		}
		return null;
	}

	/**
	 * Get the PreferencesValidator instance instead of the class name.
	 *
	 * @return the preferences validator
	 */
	@Override
	public PreferencesValidator getPreferencesValidator() {
		if (validatorInstance == null && castorPreferencesValidator != null) {
			final ClassLoader loader = Thread.currentThread().getContextClassLoader();
			try {
				final Class<?> clazz = loader.loadClass(castorPreferencesValidator);
				validatorInstance = (PreferencesValidator) clazz.newInstance();
			} catch (final Exception e) {
				LOG.error(e.getMessage(), e);
			}
		}
		return validatorInstance;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceSetCtrl#add(java.lang.String, java.util.List)
	 */
	@Override
	public Preference add(final String name, final List values) {
		final PreferenceImpl preference = new PreferenceImpl();
		preference.setName(name);
		preference.setValues(values);
		super.add(preference);
		return preference;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceSetCtrl#remove(java.lang.String)
	 */
	@Override
	public Preference remove(final String name) {
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			final Preference preference = (Preference) iterator.next();
			if (preference.getName().equals(name)) {
				super.remove(preference);
				return preference;
			}
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see org.apache.pluto.om.common.PreferenceSetCtrl#remove(org.apache.pluto.om.common.Preference)
	 */
	@Override
	public void remove(final Preference preference) {
		super.remove(preference);
	}

	// additional methods.
	/* (non-Javadoc)
	 * @see java.util.AbstractCollection#toString()
	 */
	@Override
	public String toString() {
		return toString(0);
	}

	/**
	 * To string.
	 *
	 * @param indent
	 *            the indent
	 *
	 * @return the string
	 */
	public String toString(final int indent) {
		final StringBuffer buffer = new StringBuffer(50);
		StringUtils.newLine(buffer, indent);
		buffer.append(getClass().toString());
		buffer.append(": ");
		final Iterator iterator = this.iterator();
		while (iterator.hasNext()) {
			buffer.append(((PreferenceImpl) iterator.next()).toString(indent + 2));
		}
		return buffer.toString();
	}

	// additional internal methods
	/**
	 * Gets the castor preferences validator.
	 *
	 * @return the castor preferences validator
	 */
	public String getCastorPreferencesValidator() {
		return castorPreferencesValidator;
	}

	/**
	 * Sets the castor preferences validator.
	 *
	 * @param castorPreferencesValidator
	 *            the new castor preferences validator
	 */
	public void setCastorPreferencesValidator(final String castorPreferencesValidator) {
		this.castorPreferencesValidator = castorPreferencesValidator;
	}

	/**
	 * Gets the castor preferences.
	 *
	 * @return the castor preferences
	 */
	public Collection getCastorPreferences() {
		return this;
	}

	/**
	 * Sets the class loader.
	 *
	 * @param loader
	 *            the new class loader
	 */
	public void setClassLoader(final ClassLoader loader) {
		this.classLoader = loader;
	}

	/**
	 * Adds the all.
	 *
	 * @param c
	 *            the c
	 *
	 * @return true, if adds the all
	 *
	 * @see java.util.Collection#addAll(Collection) makes a deep copy
	 */
	@Override
	public boolean addAll(final Collection c) {
		final Iterator it = c.iterator();
		while (it.hasNext()) {
			final PreferenceImpl pref = (PreferenceImpl) it.next();
			this.add(pref.getName(), pref.getClonedCastorValuesAsList());
		}
		return true; //always assume something changed
	}

	/**
	 * Gets the class loader.
	 *
	 * @return the class loader
	 */
	public ClassLoader getClassLoader() {
		return classLoader;
	}

	/**
	 * Adds the user preferences values.
	 *
	 * @param name
	 *            the name
	 * @param values
	 *            the values
	 */
	public void addUserPreferencesValues(final String name, final List values) {
		if (this.get(name) != null) {
			((PreferenceImpl) this.get(name)).addUserValues(values);
		} else {
			this.add(name, values);
		}
	}
}
