/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*

 */
package com.univ.portail.util.xml;

// TODO: Auto-generated Javadoc
/**
 * * The <CODE>XMLException</CODE> class defines a general exception * that may occur during portlet.xml or web.xml handling *
 */
public class XmlException extends Exception {

	/**
	 *
	 */
	private static final long serialVersionUID = 5605994810618873618L;

	/** The throwable. */
	private Throwable throwable = null;

	/**
	 * * Constructs a new xml exception.
	 */
	public XmlException() {
		super();
	}

	/**
	 * * Constructs a new xml exception with the given text. * * @param text * the exception text
	 *
	 * @param text
	 *            the text
	 */
	public XmlException(final String text) {
		super(text);
	}

	/**
	 * * Constructs a new xml exception to throw an * exception and include a message about the "root case" that interfered * with its normal operation, including a description
	 * message. * * @param text * the exception text * @param cause * the root cause
	 *
	 * @param text
	 *            the text
	 * @param cause
	 *            the cause
	 */
	public XmlException(final String text, final Throwable cause) {
		super(text);
		throwable = cause;
	}

	/**
	 * * Constructs a new xml exception to throw an * exception. The exception's message is based on the localized message * of the underlying exception. * * @param cause * the
	 * root cause
	 *
	 * @param cause
	 *            the cause
	 */
	public XmlException(final Throwable cause) {
		super(cause.getLocalizedMessage());
		throwable = cause;
	}

	/**
	 * Returns the exception that caused this xml exception.
	 *
	 * @return the <code>Throwable</code> that caused this xml exception
	 */
	public Throwable getRootCause() {
		return throwable;
	}
}
