/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* 

 */
package com.univ.portail.util.xml;

import java.io.InputStream;

import javax.servlet.ServletContext;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.kportal.core.config.PropertyHelper;

// TODO: Auto-generated Javadoc
/**
 * The Class XmlParser.
 */
public class XmlParser {

	//    public static Document parsePortletXml(ServletContext context, InputStream portletXml) throws IOException, SAXException
	//    {
	//        
	//        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
	//
	//        documentBuilderFactory.setAttribute("http://xml.org/sax/features/validation", Boolean.TRUE);
	//        documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", Boolean.TRUE);
	//
	//        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
	//        documentBuilderFactory.setAttribute("http://apache.org/xml/features/dom/include-ignorable-whitespace", Boolean.FALSE);
	//
	//
	//        try{
	//
	//            // throws ParserConfigurationException if documentBuilder cannot be created
	//            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder(); 
	//            documentBuilder.setErrorHandler(new ErrorHandler());
	//            documentBuilder.setEntityResolver(new EntityResolver(context, Constants.RES_PORTLET_DTDS, Constants.RES_PORTLET_DTD_NAMES)); 
	//
	//            Document returnDoc = documentBuilder.parse( portletXml );
	//            returnDoc.normalize();
	//
	//            return returnDoc;
	//
	//        } catch (ParserConfigurationException e)
	//        {
	//            throw new SAXException("Failed creating DocumentBuilder",e);
	//        }
	//    }
	//
	//    public static Document parseWebXml(ServletContext context, InputStream webXml) throws IOException, SAXException
	//    {
	//        DOMParser domParser = new DOMParser();
	//
	//        domParser.setErrorHandler(new ErrorHandler());
	//        domParser.setEntityResolver(new EntityResolver(context, Constants.RES_WEB_PUBLIC_ID,
	//                                                       Constants.RES_WEB_DTD,
	//                                                       Constants.RES_WEB_DTD_NAME));
	//            
	//	// modified by YCLI: START :: do not do validation for web.xml
	//        domParser.setFeature("http://xml.org/sax/features/validation", false);
	//	// modified by YCLI: END 
	//        domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
	//
	//        InputSource source = new InputSource( webXml );
	//        
	//        domParser.parse( source );
	//        
	//        return domParser.getDocument();
	//    }
	// private helper classes for parsing
	//    public static class ErrorHandler implements org.xml.sax.ErrorHandler
	//    {
	//
	//        // org.xml.sax.ErrorHandler implementation.
	//
	//        public void warning (SAXParseException exception) throws SAXException {
	//            throw exception;
	//        }
	//        public void error   (SAXParseException exception) throws SAXException {
	//            throw exception;
	//        }
	//        public void fatalError (SAXParseException exception) throws SAXException {
	//            throw exception;
	//        }
	//    }
	/**
	 * The Class EntityResolver.
	 */
	public static class EntityResolver implements org.xml.sax.EntityResolver {

		/** The context. */
		public ServletContext context = null;

		/** The chemin conf. */
		private String cheminConf = null;

		/** The public dtd. */
		public String publicDTD = null;

		/** The resource dt ds. */
		public String[] resourceDTDs = new String[1];

		/** The resource dtd names. */
		public String[] resourceDTDNames = new String[1];

		/**
		 * Instantiates a new entity resolver.
		 * 
		 * @param context
		 *            the context
		 * @param publicDTD
		 *            the public dtd
		 * @param resourceDTD
		 *            the resource dtd
		 * @param resourceDTDName
		 *            the resource dtd name
		 */
		public EntityResolver(final ServletContext context, final String publicDTD, final String resourceDTD, final String resourceDTDName) {
			this.cheminConf = PropertyHelper.getCoreProperty("repertoire.configuration");
			this.context = context;
			this.publicDTD = publicDTD;
			this.resourceDTDs[0] = resourceDTD;
			this.resourceDTDNames[0] = resourceDTDName;
		}

		/**
		 * Instantiates a new entity resolver.
		 * 
		 * @param context
		 *            the context
		 * @param resourceDTDs
		 *            the resource dt ds
		 * @param resourceDTDNames
		 *            the resource dtd names
		 */
		public EntityResolver(final ServletContext context, final String[] resourceDTDs, final String[] resourceDTDNames) {
			this.cheminConf = PropertyHelper.getCoreProperty("repertoire.configuration");
			this.context = context;
			this.resourceDTDs = resourceDTDs;
			this.resourceDTDNames = resourceDTDNames;
		}

		/* (non-Javadoc)
		 * @see org.xml.sax.EntityResolver#resolveEntity(java.lang.String, java.lang.String)
		 */
		@Override
		public InputSource resolveEntity(final String publicId, final String systemId) throws SAXException {
			for (int i = 0; i < resourceDTDNames.length; i++) {
				if ((publicId != null && publicId.equals(publicDTD)) || (systemId != null && systemId.endsWith(resourceDTDNames[i]))) {
					final InputStream is = context.getResourceAsStream(cheminConf + resourceDTDs[i]);
					if (is != null) {
						return new InputSource(is);
					}
					throw new SAXException("XML configuration DTD not found: " + cheminConf + resourceDTDs[i]);
				}
			}
			// no other external entity permitted
			throw new SAXException("External entites are not permitted in XML configuration files");
		}
	}
}
