/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 25 avr. 2005
 *
 * Servlet destiné à renvoyée des informations personnalisées pour le portlet
 * distant
 */
package com.univ.portlet.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.net.URLEncoder;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.identification.ValidateurCAS;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.kportal.servlet.ExtensionServlet;
import com.univ.objetspartages.om.Encadre;
import com.univ.portail.util.PortletHelper;
import com.univ.utils.ContexteUniv;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;
import com.univ.xhtml.XHTMLFormater;

// TODO: Auto-generated Javadoc
/**
 * The Class PortletEncadreServlet.
 *
 * @author jeanseb
 *
 *         Webservice permettant de renvoyer le contenu d'un encadré (au format XHTML) vers un portlet
 *
 *         Concu pour être intégré dans e-sup
 */
@WebServlet(name = "portletEncadreServlet", urlPatterns = "/servlet/com.univ.portlet.server.PortletEncadreServlet", loadOnStartup = 0)
public class PortletEncadreServlet extends ExtensionServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = -5397826598375869079L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(PortletEncadreServlet.class);

	/** The g i. */
	private static GestionnaireIdentification gI;

	/**
	 * Transformation des liens avant l'export.
	 *
	 * @param node
	 *            the node
	 *
	 * @throws Exception
	 *             the exception
	 */
	private static void processNode(final Node node) throws Exception {
		final int type = node.getNodeType();
		if ((type == Node.ELEMENT_NODE) && (node.getNodeName().equalsIgnoreCase("a"))) {
			final NamedNodeMap attributes = node.getAttributes();
			if (attributes != null) {
				/* Si l'url ne commence pas par "http://" , on rajoute le host */
				final Node href = attributes.getNamedItem("href");
				if (href != null) {
					final ContexteUniv ctx = new ContexteUniv("");
					String url = href.getNodeValue();
					if (!url.toLowerCase().startsWith("http://")) {
						if (url.charAt(0) != '/') {
							url = "/" + url;
						}
						url = URLResolver.getAbsoluteUrl(url, ctx);
					}
					// On enlève les '/' doublés qui posent un pb d'encodage
					// (cas du lien de contribution front 'soumettreactu)
					// (Report de patch JSS 18/11)
					// TODO : Tester en 4.2 si vraiment nécessaire, sinon enlever
					url = "http://" + url.substring(7).replaceAll("//", "/");
					// TODO : uniquement si CAS
					gI = GestionnaireIdentification.getInstance();
					/* Redirection CAS */
					if (gI.estSourceAuth(ValidateurCAS.SOURCE_LIBELLE_CAS)) {
						final String host = URLResolver.getAbsoluteUrl("", ctx);
						if (url.startsWith(host)) {
							url = URLResolver.getAbsoluteUrl("/adminsite/sso/casauth.jsp?cible=" + URLEncoder.encode(url.substring(host.length()), CharEncoding.DEFAULT), ctx);
						}
					}
					href.setNodeValue(url);
				}
				/* Ajout d'un target = "_blank" */
				Node target = attributes.getNamedItem("target");
				if (target == null) {
					target = node.getOwnerDocument().createAttribute("target");
					target.setNodeValue("_blank");
					attributes.setNamedItem(target);
				}
			}
		}
		final NodeList children = node.getChildNodes();
		if (children != null) {
			final int len = children.getLength();
			//Iterate on NodeList of child nodes.
			for (int i = 0; i < len; i++) {
				//Process each of the nested elements
				// recursively.
				processNode(children.item(i));
			}//end for loop
		}//end if children
	}

	/**
	 * Preparer contenu.
	 *
	 * @param _ctx
	 *            the _ctx
	 * @param writer
	 *            the writer
	 * @param _codeEncadre
	 *            the _code encadre
	 *
	 * @return the string
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static String preparerContenu(final ContexteUniv _ctx, final Writer writer, final String _codeEncadre) throws Exception {
		String resultat = "";
		final Encadre encadre = new Encadre();
		encadre.setCtx(_ctx);
		encadre.init();
		if (encadre.select("WHERE CODE='" + _codeEncadre + "'") == 1) {
			encadre.nextItem();
			//	Transformation XHTML par tidy
			final XHTMLFormater xhtmlf = new XHTMLFormater();
			resultat = xhtmlf.transformHTMLtoXML(UnivWebFmt.formaterEnHTML(_ctx, encadre.getContenu()));
		} else {
			resultat = "Contenu inexistant";
		}
		return resultat;
	}

	/**
	 * Renvoyer contenu.
	 *
	 * @param writer
	 *            the writer
	 * @param resultat
	 *            the resultat
	 */
	public static void renvoyerContenu(final Writer writer, String resultat) {
		try {
			final DocumentBuilderFactory factory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
			final DocumentBuilder builder = factory.newDocumentBuilder();
			resultat = "<root>" + resultat + "</root>";
			final org.w3c.dom.Document document = builder.parse(new ByteArrayInputStream(resultat.getBytes(CharEncoding.DEFAULT)));
			// Transformation de l'arbre XML
			processNode(document);
			//String resultat= "<p>coucou</p>";
			final TransformerFactory transFactory = TransformerFactory.newInstance();
			final Transformer transformer = transFactory.newTransformer();
			/*
			 * Using the DOM tree root node, the following line of code constructs a
			 * DOMSource object as the source of the transformation.
			 */
			final DOMSource source = new DOMSource(document);
			/*
			 * The following code fragment creates a StreamResult object to take the
			 * results of the transformation and transforms the tree to XML.
			 */
			final StreamResult result = new StreamResult(writer);
			transformer.setOutputProperty(OutputKeys.ENCODING, CharEncoding.DEFAULT);
			transformer.transform(source, result);
			//writer.write( resultat);
		} catch (final Exception e) {
			LOG.error("erreur lors du renvoi de contenu", e);
		}
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServlet#service(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	@Override
	public void service(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
		final Writer writer = res.getWriter();
		String resultat = "";
		try {
			//ContexteUniv ctx = initialiserContexte(req);
			LOG.debug(" Portletencadreservlet user = " + req.getParameter("USER") + " encadre=" + req.getParameter("ENCADRE"));
			final ContexteUniv ctx = GestionnaireIdentification.getInstance().initialiserContexteProxyClient(req);
			resultat = preparerContenu(ctx, res.getWriter(), req.getParameter("ENCADRE"));
			ctx.release();
		} catch (final Exception e) {
			LOG.error("erreur sur les portlets", e);
			resultat = "Contenu indisponible";
		}
		res.setContentType("application/xhtml");
		renvoyerContenu(writer, resultat);
	}

	@Override
	public boolean isActive() {
		return PortletHelper.isPortletActivated();
	}
}
