/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.rss;

/**
 * Superclasse des classes chargées de récupérer les flux rss
 * 
 * @author aga
 */
public abstract class AbstractRequeteRSS implements Runnable {

	/**
	 * Référence vers le gestionnaire de flux rss
	 */
	private RequeteMultiRSS requeteMulti;

	/**
	 * nombre de réponse max à renvoyer
	 */
	private int maxReponses;

	/**
	 * Url du flux rss a récupérer
	 */
	private String url;

	/**
	 * Un constructeur
	 * 
	 * @param requeteMulti
	 *            Référence vers le gestionnaire de flux rss
	 * @param maxReponses
	 *            nombre de réponse max à renvoyer
	 * @param url
	 *            Url du flux rss a récupérer
	 */
	public AbstractRequeteRSS(RequeteMultiRSS requeteMulti, int maxReponses, String url) {
		this.requeteMulti = requeteMulti;
		this.maxReponses = maxReponses;
		this.url = url;
	}

	/**
	 * @return the requeteMulti
	 */
	protected RequeteMultiRSS getRequeteMulti() {
		return requeteMulti;
	}

	/**
	 * @param requeteMulti
	 *            the requeteMulti to set
	 */
	protected void setRequeteMulti(RequeteMultiRSS requeteMulti) {
		this.requeteMulti = requeteMulti;
	}

	/**
	 * @return the maxReponses
	 */
	protected int getMaxReponses() {
		return maxReponses;
	}

	/**
	 * @param maxReponses
	 *            the maxReponses to set
	 */
	protected void setMaxReponses(int maxReponses) {
		this.maxReponses = maxReponses;
	}

	/**
	 * @return the url
	 */
	protected String getUrl() {
		return url;
	}

	/**
	 * @param url
	 *            the url to set
	 */
	protected void setUrl(String url) {
		this.url = url;
	}
}
