/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.rss;

import java.lang.reflect.Method;

import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.om.Article;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.Ressource;
import com.univ.objetspartages.om.Structure;
import com.univ.utils.ContexteUniv;
import com.univ.utils.RequeteUtil;
import com.univ.utils.URLResolver;
import com.univ.utils.UnivWebFmt;

// TODO: Auto-generated Javadoc
/**
 * Gestionnaire d'export RSS sur des articles.
 * 
 * @author fred
 */
public class ExportRssArticle extends AbstractExportRss {

	/**
	 * Instantiates a new export rss article.
	 *
	 * @param query
	 *            the query
	 * @param objectName
	 *            the object name
	 * @param feedType
	 *            the feed type
	 */
	public ExportRssArticle(final String query, final String objectName, final String feedType) {
		super(query, objectName, feedType);
	}

	/**
	 * Renvoie la description du channel correspondant à cet export rss.
	 * 
	 * @return La description du channel
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected String getDescription(final OMContext ctx) throws Exception {
		// on recupere la description dans la requete
		String description = super.getDescription(ctx);
		if (description.length() == 0) // sinon
		{
			final String thematique = RequeteUtil.renvoyerParametre(getQuery(), "THEMATIQUE");
			if (thematique.length() > 0) {
				description += "\"" + Libelle.getLibelle("04", thematique, ctx.getLocale()) + "\" ";
			}
			final String codeRattachement = RequeteUtil.renvoyerParametre(getQuery(), "CODE_RATTACHEMENT");
			if (codeRattachement.length() > 0) {
				description += "[" + Structure.getLibelleRattachement(ctx, codeRattachement, "0", true).replaceAll("<br />", " / ") + "]";
			}
			if (description.length() == 0) {
				description = "Les 10 derniers articles";
			} else {
				description = "Sélection " + description;
			}
		}
		return description;
	}

	/**
	 * Renvoie le titre de l'actu.
	 * 
	 * @param fiche
	 *            L'actu à exporter
	 * 
	 * @return Le titre
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected String getItemTitle(final FicheUniv fiche) throws Exception {
		return ((Article) fiche).getTitre();
	}

	/**
	 * Renvoie la description de l'actu.
	 * 
	 * @param fiche
	 *            L'actu à exporter
	 * 
	 * @return La description
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected String getItemDescription(final ContexteUniv ctx, final FicheUniv fiche) throws Exception {
		String description = "";
		final Ressource ressource = Ressource.getFichier(fiche);
		if (ressource != null) {
			final String urlVignette = URLResolver.getAbsoluteUrl(ressource.getUrlVignette(), ctx);
			description = "<img src=\"" + urlVignette + "\" width=\"150px\" /><br />";
		}
		final String optionExport = PropertyHelper.getCoreProperty("export_rss.article.description");
		if (optionExport == null || optionExport.length() == 0) {
			description += ((Article) fiche).getContenu();
		} else {
			try {
				// Récupération de la liste de valeurs
				final String nomAccesseurGET = "get" + optionExport.substring(0, 1).toUpperCase() + optionExport.substring(1);
				// ex méthode getParcourss() sur l'objet Formation 
				final Method accesseurGET = fiche.getClass().getMethod(nomAccesseurGET, new Class[0]);
				final Object o[] = new Object[0];
				description += (String) accesseurGET.invoke(fiche, o);
			} catch (final Exception e) {
				throw new ErreurApplicative("Attribut " + optionExport + " pour la fiche Article");
			}
		}
		//	on a besoin de cette info pour le formatage HTML
		ctx.setFicheCourante(fiche);
		return UnivWebFmt.formaterEnHTML(ctx, description);
	}
}
