/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.rss;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

// TODO: Auto-generated Javadoc
/**
 * Bean contenant les informations d'un élément d'un flux RSS.
 */
public class RSSBean {

	/** The title. */
	private String title = "";

	/** The description. */
	private String description = "";

	/** The link. */
	private String link = "";

	/** The date. */
	private Date date = null;

	/** The creator. */
	private String creator = "";

	/**
	 * liste de tag media:content (yahoo mediarss) du flux rss
	 */
	private final List<RSSMediaContentBean> mediaContentList = new ArrayList<RSSMediaContentBean>();

	/**
	 * Gets the description.
	 * 
	 * @return String
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * Gets the link.
	 * 
	 * @return String
	 */
	public String getLink() {
		return link;
	}

	/**
	 * Gets the title.
	 * 
	 * @return String
	 */
	public String getTitle() {
		return title;
	}

	/**
	 * Sets the description.
	 * 
	 * @param description
	 *            String
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/**
	 * Sets the link.
	 * 
	 * @param link
	 *            String
	 */
	public void setLink(String link) {
		this.link = link;
	}

	/**
	 * Sets the title.
	 * 
	 * @param title
	 *            String
	 */
	public void setTitle(String title) {
		this.title = title;
	}

	/**
	 * Gets the date.
	 * 
	 * @return Returns the date.
	 */
	public Date getDate() {
		return date;
	}

	/**
	 * Sets the date.
	 * 
	 * @param date
	 *            The date to set.
	 */
	public void setDate(Date date) {
		this.date = date;
	}

	/**
	 * Gets the creator.
	 * 
	 * @return Returns the creator.
	 */
	public String getCreator() {
		return creator;
	}

	/**
	 * Sets the creator.
	 * 
	 * @param creator
	 *            The creator to set.
	 */
	public void setCreator(String creator) {
		this.creator = creator;
	}

	/**
	 * @return la liste de tag media:content (yahoo mediarss) du flux rss
	 */
	public List<RSSMediaContentBean> getMediaContentList() {
		return mediaContentList;
	}

	public void addAllMedia(List<RSSMediaContentBean> list) {
		for (RSSMediaContentBean mediaContentBean : list) {
			if (!mediaContentList.contains(mediaContentBean)) {
				mediaContentList.add(mediaContentBean);
			}
		}
	}

	public void addMedia(RSSMediaContentBean media) {
		if (!mediaContentList.contains(media)) {
			mediaContentList.add(media);
		}
	}
}
