/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.rss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

import com.kportal.core.config.PropertyHelper;
import com.univ.rss.impl.rome.RequeteRSSImplRome;

// TODO: Auto-generated Javadoc
/**
 * Lance les requêtes en simultané sur plusieurs sites. NOTE : multithread et multisite inutile pour cette fonctionnalité
 */
public class RequeteMultiRSS {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(RequeteMultiRSS.class);

	/** The resultats. */
	private ArrayList<RSSBean> resultats = null;

	private String titre = "";

	private String description = "";

	/**
	 * Constructeur.
	 */
	public RequeteMultiRSS() {
		this.resultats = new ArrayList<RSSBean>();
	}

	/**
	 * Méthode de lancement du requêteur multiple sur un flux rss.
	 *
	 * @param param
	 *            Les paramètres de la requête
	 *
	 * @return the vector
	 */
	public Vector<RSSBean> lancerRequetes(final String param) {
		// Analyse des paramètres
		final Vector<String> vUrls = new Vector<String>();
		int maxResultats = 0;
		final int indicePlus = param.indexOf("+");
		// si pas de +
		if (indicePlus == -1) {
			vUrls.add(StringUtils.replace(param, "&amp;", "&"));
			maxResultats = 100;
		} else {
			//sinon, on prend le premier + et on coupe la chaine (permet d'avoir des urls rss qui contiennent un +
			try {
				//format NB+URL
				maxResultats = Integer.parseInt(param.substring(0, indicePlus));
				vUrls.add(StringUtils.replace(param.substring(indicePlus + 1), "&amp;", "&"));
			} catch (final NumberFormatException e) {
				//si le + s'avère être dans l'url et pas un séparateur, dans ce cas on met tout param dans l'url
				vUrls.add(StringUtils.replace(param, "&amp;", "&"));
				maxResultats = 100;
			} catch (final Exception e) {
				//autre type d'erreur, on ignore l'url
				LOG.error("mauvaise URL peut être?", e);
			}
		}
		final ArrayList<Thread> lstTread = new ArrayList<Thread>();
		// Lancement des requêtes
		try {
			// Création des requêtes
			AbstractRequeteRSS requete = null;
			for (int i = 0; i < vUrls.size(); i++) {
				requete = new RequeteRSSImplRome(this, maxResultats, vUrls.get(i));
				final Thread threadRequete = new Thread(requete);
				threadRequete.start();
				lstTread.add(threadRequete);
			}
			// Pour chaque thread crée on spécifie un timeout 2s par defaut
			long to = 2000;
			if (PropertyHelper.getCoreProperty("import_rss.timeout") != null) {
				try {
					to = Long.valueOf(PropertyHelper.getCoreProperty("import_rss.timeout"));
				} catch (final Exception e) {}
			}
			for (final Thread thread : lstTread) {
				thread.join(to);
			}
		} catch (final Exception e) {
			LOG.error("erreur lors de l'appel du thread", e);
		}
		// Parcours des résultats pour stocker dans le vecteur
		final Vector<RSSBean> res = new Vector<RSSBean>();
		final Iterator<RSSBean> iter = resultats.iterator();
		while (iter.hasNext()) {
			res.add(iter.next());
		}
		return res;
	}

	/**
	 * Ajouter resultat.
	 *
	 * @param rss
	 *            the rss
	 */
	public synchronized void ajouterResultat(final RSSBean rss) {
		//String dateInversee = "" + (new Long(9999999999999L - rss.getDate().getTime()));
		//String critereTri = dateInversee + "/" + rss.getTitle();
		//resultats.put(critereTri.toUpperCase(), rss);
		resultats.add(rss);
	}

	/**
	 * Indique au gestionnaire qu'un thread a fini de s'exécuter.
	 */
	public synchronized void decrementerCptRequetes() {}

	public String getTitre() {
		return titre;
	}

	public void setTitre(final String titre) {
		this.titre = titre;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}
}
