/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Gestionnaire de caches de services
 */
package com.univ.services;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;

import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.pluto.PortletContainerException;
import org.apache.pluto.om.window.PortletWindow;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.identification.GestionnaireIdentification;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import com.univ.objetspartages.om.ServiceBean;
import com.univ.portail.KportalPortletFragment;
import com.univ.portail.core.PortalEnvironment;
import com.univ.portail.core.PortletContainerFactory;
import com.univ.portail.service.registry.PortletOccurenceRegistry;
import com.univ.utils.ContexteUniv;
import com.univ.utils.RequeteUtil;
import com.univ.utils.ServiceWrappedResponse;
import com.univ.utils.ServicesUtil;
import com.univ.utils.URLResolver;

// TODO: Auto-generated Javadoc
/**
 * Gestion synchronisée des caches mémoire consultation mise à jour expiration depuis applications externes.
 */
public class CacheServiceViewManager {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(CacheServiceViewManager.class);

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "cacheServiceViewManager";

	/**
	 * Execution de la vue réduite
	 *
	 * Pour l'instant, seule l'url est gérée.
	 *
	 * @param key
	 *            the key
	 * @param expirationCache
	 *            the expiration cache
	 * @param ctx
	 *            the ctx
	 * @param serviceBean
	 *            the service bean
	 * @param nomVue
	 *            the nom vue
	 *
	 * @return @throws Exception
	 *
	 * @throws Exception
	 *             the exception
	 */
	@TempCacheGet(key = "CacheServiceViewManager.getServiceView", contextual = false)
	public String getServiceView(final String key, final Integer expirationCache, final ContexteUniv ctx, final ServiceBean serviceBean, final String nomVue) throws Exception {
		String contenu = "";
		String url = "";
		if (serviceBean.getVueReduiteType().equals("1")) {
			url = serviceBean.getVueReduiteUrl();
			if (nomVue.length() > 0) {
				url += (!url.contains("?") ? "?" : "&");
				url += "nomvue=" + nomVue;
			}
			String kticket = "";
			if (serviceBean.getJetonKportal().equals("1")) {
				kticket = ServicesUtil.genererTicketService(ctx);
			}
			url = ServicesUtil.ajouterParametresService(ctx, serviceBean, url, kticket);
			/* Ajout proxy CAS */
			if (serviceBean.getProxyCas().equals("1")) {
				final String ticket = GestionnaireIdentification.getInstance().getValidateurCAS().getProxyTicket(ctx.getCode(), ctx.getCodeGestion(), url);
				if (ticket != null) {
					url += (!url.contains("?") ? "?" : "&");
					url += "PT=" + ticket;
				}
			}
		}
		if (url.length() > 0) {
			// Si l'url commence par /, on rajoute le host
			if (url.charAt(0) == '/') {
				url = URLResolver.getAbsoluteUrl(url, ctx);
			}
			LOG.debug("*** url service appelée " + url);
			try {
				final URL urlAppel = new URL(url);
				final URLConnection urlConnection = urlAppel.openConnection();
				String ligne = "";
				InputStreamReader reader = null;
				/* Gestion de l'encodage */
				if (serviceBean.getEncodage().equals("")) {
					reader = new InputStreamReader(urlConnection.getInputStream());
				} else {
					String encodage = "";
					if (serviceBean.getEncodage().equals("I")) {
						encodage = CharEncoding.DEFAULT;
					}
					if (serviceBean.getEncodage().equals("U")) {
						encodage = CharEncoding.DEFAULT;
					}
					reader = new InputStreamReader(urlConnection.getInputStream(), encodage);
				}
				final BufferedReader flux = new BufferedReader(reader);
				while ((ligne = flux.readLine()) != null) {
					contenu += ligne;
				}
				flux.close();
			} catch (final Exception e) {
				LOG.error("erreur lors de l'appel de l'url", e);
			}
		}
		/* Appel par requestdispatcher */
		if (serviceBean.getVueReduiteType().equals("2")) {
			if (ctx.getRequeteHTTP() != null && ctx.getReponseHTTP() != null && ctx.getServletContext() != null) {
				url = serviceBean.getVueReduiteUrlCrossCtx();
				String kticket = "";
				if (serviceBean.getJetonKportal().equals("1")) {
					kticket = ServicesUtil.genererTicketService(ctx);
				}
				url = ServicesUtil.ajouterParametresService(ctx, serviceBean, url, kticket);
				/* Ajout proxy CAS */
				if (serviceBean.getProxyCas().equals("1")) {
					final String ticket = GestionnaireIdentification.getInstance().getValidateurCAS().getProxyTicket(ctx.getCode(), ctx.getCodeGestion(), url);
					if (ticket != null) {
						url += (!url.contains("?") ? "?" : "&");
						url += "PT=" + ticket;
					}
				}
				final HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(ctx.getRequeteHTTP());
				final StringWriter storedWriter = new StringWriter();
				final PrintWriter writer = new PrintWriter(storedWriter);
				final HttpServletResponseWrapper wrappedResponse = new ServiceWrappedResponse(ctx.getReponseHTTP(), writer);
				ServletContext ctxServlet = ctx.getServletContext();
				if (serviceBean.getVueReduiteCtx().length() > 0) {
					ctxServlet = ctxServlet.getContext(serviceBean.getVueReduiteCtx());
				}
				//RequestDispatcher rd = ctxServlet.getRequestDispatcher(service.getVueReduiteUrlCrossCtx());
				final RequestDispatcher rd = ctxServlet.getRequestDispatcher(url);
				LOG.debug("*** url service appelée " + url);
				rd.include(wrappedRequest, wrappedResponse);
				contenu = storedWriter.toString();
			}
		}
		return contenu;
	}

	/**
	 * Gets the portlet view.
	 *
	 * @param key
	 *            the key
	 * @param expirationCache
	 *            the expiration cache
	 * @param portletWindow
	 *            the portlet window
	 * @param storedWriter
	 *            the stored writer
	 * @param wrappedRequest
	 *            the wrapped request
	 * @param wrappedResponse
	 *            the wrapped response
	 *
	 * @return the portlet view
	 *
	 * @throws PortletException
	 *             the portlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 * @throws PortletContainerException
	 *             the portlet container exception
	 */
	@TempCacheGet(key = "CacheServiceViewManager.getServiceView", contextual = false)
	public String getPortletView(final String key, final Integer expirationCache, final PortletWindow portletWindow, final StringWriter storedWriter,
		final HttpServletRequest wrappedRequest, final HttpServletResponse wrappedResponse) throws PortletException, IOException, PortletContainerException {
		PortletContainerFactory.getPortletContainer().portletLoad(portletWindow, wrappedRequest, wrappedResponse);
		PortletContainerFactory.getPortletContainer().renderPortlet(portletWindow, wrappedRequest, wrappedResponse);
		return storedWriter.toString();
	}

	/**
	 * Flush view.
	 *
	 * @param key
	 *            the key
	 */
	@TempCacheFlush(key = "CacheServiceViewManager.getServiceView", contextual = false)
	public void flushView(final String key) {}

	/**
	 * Gets the contenu portlet.
	 *
	 * @param ctx
	 *            the ctx
	 * @param serviceBean
	 *            the service bean
	 * @param codePortlet
	 *            the code portlet
	 *
	 * @return the contenu portlet
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static String getContenuPortlet(final ContexteUniv ctx, final ServiceBean serviceBean, final String codePortlet) throws Exception {
		final HttpServletRequest rq = ctx.getRequeteHTTP();
		if (ctx.getRequeteHTTP().getAttribute(PortalEnvironment.REQUEST_PORTALENV) == null) {
			new PortalEnvironment(rq, ctx.getReponseHTTP());
		}
		KportalPortletFragment fragment = PortletOccurenceRegistry.getOccurence(codePortlet);
		if (fragment == null) {
			fragment = PortletOccurenceRegistry.ajouterFragment(codePortlet);
		}
		return fragment.service(ctx, serviceBean.getEncodage());
	}

	/**
	 * Gets the contenu portlet.
	 *
	 * @param ctx
	 *            the ctx
	 * @param service
	 *            the service
	 * @param portletWindow
	 *            the portlet window
	 * @param storedWriter
	 *            the stored writer
	 * @param wrappedRequest
	 *            the wrapped request
	 * @param wrappedResponse
	 *            the wrapped response
	 *
	 * @return the contenu portlet
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static String getContenuPortlet(final ContexteUniv ctx, final ServiceBean service, final PortletWindow portletWindow, final StringWriter storedWriter,
		final HttpServletRequest wrappedRequest, final HttpServletResponse wrappedResponse) throws Exception {
		final String key = ctx.getKsession() + "@" + service.getCode() + "@" + portletWindow.getId().toString();
		final CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager) ApplicationContextManager.getCoreContextBean(CacheServiceViewManager.ID_BEAN);
		return cacheServiceMgr.getPortletView(key, service.getExpirationCache(), portletWindow, storedWriter, wrappedRequest, wrappedResponse);
	}

	/**
	 * Supprime le cache d'un service à partir d'une application externe.
	 *
	 * @param _ctx
	 *            the _ctx
	 * @param writer
	 *            the writer
	 * @param _requete
	 *            the _requete
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static void suppressionCacheService(final ContexteUniv _ctx, final Writer writer, final String _requete) throws Exception {
		LOG.debug("suppressionCacheParIdentifiantExterne cache externe ");
		final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		final DocumentBuilder builder = factory.newDocumentBuilder();
		final String codeRetour = "0";
		final String ksession = RequeteUtil.renvoyerParametre(_requete, "ksession");
		final String codeService = RequeteUtil.renvoyerParametre(_requete, "service");
		final com.univ.objetspartages.om.ServiceBean service = ServicesUtil.getService(codeService);
		final String key = ksession + "@" + codeService + "@" + service.getVueReduiteUrl();
		final CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager) ApplicationContextManager.getCoreContextBean(CacheServiceViewManager.ID_BEAN);
		cacheServiceMgr.flushView(key);
		/** *********************************************** */
		/* Génération du fichier XML SSO */
		/** *********************************************** */
		final TransformerFactory transFactory = TransformerFactory.newInstance();
		final Transformer transformer = transFactory.newTransformer();
		Document document = builder.newDocument();
		final org.w3c.dom.Node nodeFiche = document.createElement("REPONSE_KPORTAL");
		final org.w3c.dom.Node nodeCodeRetour = document.createElement("CODE_RETOUR");
		nodeCodeRetour.appendChild(document.createTextNode(codeRetour));
		nodeFiche.appendChild(nodeCodeRetour);
		document.appendChild(nodeFiche);
		/*
		 * Using the DOM tree root node, the following line of code constructs a
		 * DOMSource object as the source of the transformation.
		 */
		final DOMSource source = new DOMSource(document);
		/*
		 * The following code fragment creates a StreamResult object to take the
		 * results of the transformation and transforms the tree to XML.
		 */
		final StreamResult result = new StreamResult(writer);
		transformer.setOutputProperty(OutputKeys.ENCODING, "utf-8");
		transformer.transform(source, result);
	}

	/**
	 * Gets the contenu service.
	 *
	 * @param ctx
	 *            the ctx
	 * @param requete
	 *            the requete
	 *
	 * @return the contenu service
	 *
	 * @throws Exception
	 *             the exception
	 */
	public static String getContenuService(final ContexteUniv ctx, final RequeteService requete) throws Exception {
		String contenu = "";
		// Appel du service de type Portlet
		if ("P".equals(requete.getService().getType())) {
			contenu = CacheServiceViewManager.getContenuPortlet(ctx, requete.getService(), requete.codePortlet());
		} else {
			// cle de la vue
			final String key = ctx.getKsession() + "@" + requete.getService().getCode() + "@" + requete.getVue();
			final CacheServiceViewManager cacheServiceMgr = (CacheServiceViewManager) ApplicationContextManager.getCoreContextBean(CacheServiceViewManager.ID_BEAN);
			contenu = cacheServiceMgr.getServiceView(key, requete.getService().getExpirationCache(), ctx, requete.getService(), requete.getVue());
		}
		return contenu;
	}
}
