/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 14 sept. 2005
 *
 */
package com.univ.services;

import com.univ.objetspartages.om.ServiceBean;

// TODO: Auto-generated Javadoc
/**
 * The Class RequeteService.
 * 
 * @author jeanseb
 * 
 *         Permet de stocker la requête d'un thread
 */
public class RequeteService {

	/** The service. */
	ServiceBean service = null;

	/** The vue. */
	String vue = "";

	/** The id page. */
	String idPage = "";

	/** The code portlet. */
	String codePortlet = "";

	/**
	 * The Constructor.
	 * 
	 * @param service
	 *            the service
	 * @param vue
	 *            the vue
	 * @param codePortlet
	 *            the code portlet
	 */
	public RequeteService(ServiceBean service, String vue, String codePortlet) {
		super();
		this.service = service;
		this.vue = vue;
		this.codePortlet = codePortlet;
	}

	/**
	 * Gets the service.
	 * 
	 * @return the service
	 */
	public ServiceBean getService() {
		return service;
	}

	/**
	 * Gets the vue.
	 * 
	 * @return the vue
	 */
	public String getVue() {
		return vue;
	}

	/**
	 * Code portlet.
	 * 
	 * @return the string
	 */
	public String codePortlet() {
		return codePortlet;
	}

	/**
	 * Gets the id page.
	 * 
	 * @return the id page
	 */
	public String getIdPage() {
		return idPage;
	}
}
