/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Gestion des appels  de service
 */
package com.univ.services;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

import org.slf4j.LoggerFactory;

import com.kportal.core.config.PropertyHelper;
import com.univ.utils.ContexteUniv;

// TODO: Auto-generated Javadoc
/**
 * Lancement de n threads (un par service) en passant par un pool de threads puis attente de toutes les réponses
 * 
 * Les données envoyées et recues sont stockées dans une Map.
 * 
 * @author jeanseb
 */
public class ServicesInvoker {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(ServicesInvoker.class);

	/** The nb requetes traitees. */
	int nbRequetesTraitees = 0;

	// Timeout par défaut en secondes
	/** The Constant TIMEOUT_THREAD. */
	private static final int TIMEOUT_THREAD = 10;

	/** The reponses. */
	Hashtable<String, ReponseService> reponses = new Hashtable<String, ReponseService>();

	/**
	 * Executer.
	 * 
	 * @param _ctx
	 *            the _ctx
	 * @param _requetes
	 *            the _requetes
	 * 
	 * @return the map
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public Map<String, ReponseService> executer(final ContexteUniv _ctx, final Map<String, RequeteService> _requetes) throws Exception {
		LOG.debug("ServicesInvoker  -- début");
		final Iterator<String> iter = _requetes.keySet().iterator();
		while (iter.hasNext()) {
			final String cleRequete = iter.next();
			final RequeteService requete = _requetes.get(cleRequete);
			// Création d'un enregistrement pour la réponse
			reponses.put(cleRequete, new ReponseService());
			// Création de l'action
			final ServiceThread thread = new ServiceThread(this, _ctx, cleRequete, requete);
			ThreadsPool.getInstance().execute(thread);
		}
		// Boucle jusquà la fin ou + de 5s.
		final long debut = System.currentTimeMillis();
		int timeout = TIMEOUT_THREAD;
		final String sTimeout = PropertyHelper.getCoreProperty("services.timeout_execution");
		if (sTimeout != null) {
			timeout = Integer.parseInt(sTimeout);
		}
		while (estTermine() == false && System.currentTimeMillis() - debut < timeout * 1000) {
			;
		}
		LOG.debug("ServicesInvoker  -- fin");
		return reponses;
	}

	/**
	 * Fin requete.
	 * 
	 * @param _idRequete
	 *            the _id requete
	 * @param _reponse
	 *            the _reponse
	 */
	protected synchronized void finRequete(final String _idRequete, final String _reponse) {
		reponses.get(_idRequete).setTerminated(true);
		reponses.get(_idRequete).setReponse(_reponse);
		nbRequetesTraitees++;
	}

	/**
	 * Est termine.
	 * 
	 * @return true, if successful
	 * 
	 * @throws Exception
	 *             the exception
	 */
	private synchronized boolean estTermine() throws Exception {
		final boolean res = (nbRequetesTraitees == reponses.size());
		if (res == false) {
			wait(100);
		}
		return res;
	}
}