/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.synchro;

import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.database.OMContext;
import com.kportal.core.config.PropertyHelper;
import com.univ.objetspartages.cache.CacheGroupeDsiManager;
import com.univ.objetspartages.om.Groupedsi;
import com.univ.objetspartages.om.StructureModele;

// TODO: Auto-generated Javadoc
/**
 * Création automatique de groupes DSI et synchronisation des rattachements en fonction de la structure.
 */
public class SynchroGroupedsiStructure {

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(SynchroGroupedsiStructure.class);

	/** The Constant PARAM_JTF_SYNCHRO_GROUPESDSI. */
	private final static String PARAM_JTF_SYNCHRO_GROUPESDSI = "static.synchro_struct_groupesdsi";

	/** The Constant PARAM_JTF_DSI. */
	private final static String PARAM_JTF_DSI = "dsi.activation";

	/**
	 * Synchroniser groupe dsi.
	 * 
	 * @param ctx
	 *            the ctx
	 * @param structure
	 *            the structure
	 */
	public static void synchroniserGroupeDsi(final OMContext ctx, final StructureModele structure) {
		synchroniserGroupeDsi(ctx, structure, false);
	}

	/**
	 * Synchroniser groupe dsi.
	 * 
	 * @param ctx
	 *            the ctx
	 * @param structure
	 *            the structure
	 * @param isImport
	 *            the is import
	 */
	public static void synchroniserGroupeDsi(final OMContext ctx, final StructureModele structure, final boolean isImport) {
		// JB 20050822 : la création des groupes DSI devient optionnelle, mais par défaut elle est activée (cf jtf)
		boolean bSynchroCreationGroupesDSI = true;
		final String paramSynchro = PropertyHelper.getCoreProperty(PARAM_JTF_SYNCHRO_GROUPESDSI);
		if (paramSynchro != null) {
			bSynchroCreationGroupesDSI = paramSynchro.startsWith("1");
		}
		//AM 20051027 : si la dsi est désactivée, on ne génère pas non plus ces groupes
		final String paramDsi = PropertyHelper.getCoreProperty(PARAM_JTF_DSI);
		if (paramDsi == null || !paramDsi.equals("1")) {
			bSynchroCreationGroupesDSI = false;
		}
		try {
			if (bSynchroCreationGroupesDSI) {
				final Groupedsi groupedsi = new Groupedsi();
				groupedsi.setCtx(ctx);
				groupedsi.init();
				final String typeGroupeStructure = "STRUCT";
				final String codeGroupeStructure = typeGroupeStructure + "_" + structure.getCode();
				// JSS 20040419 : On synchronise le rattachement du groupe
				String codeRattachement = structure.getCodeRattachement();
				if (codeRattachement.equals("00")) {
					codeRattachement = "";
				}
				// Ajout STRUCT_ pour le code du groupe
				if (codeRattachement.length() > 0) {
					codeRattachement = typeGroupeStructure + "_" + codeRattachement;
				}
				final int count = groupedsi.select(codeGroupeStructure, "", "", "", "");
				if (count == 0) {
					// Création d'un nouveau groupe
					groupedsi.init();
					groupedsi.setCode(codeGroupeStructure);
					groupedsi.setCodeGroupePere(codeRattachement);
					String libelle = (structure).getLibelleCourt();
					if (libelle.length() == 0) {
						libelle = (structure).getLibelleLong();
					}
					groupedsi.setLibelle(libelle);
					groupedsi.setType(typeGroupeStructure);
					groupedsi.setCodeStructure(structure.getCode());
					groupedsi.add();
				} else {
					groupedsi.nextItem();
					groupedsi.setCodeGroupePere(codeRattachement);
					groupedsi.update();
				}
				if (!isImport) {
					final CacheGroupeDsiManager cache = (CacheGroupeDsiManager) ApplicationContextManager.getCoreContextBean(CacheGroupeDsiManager.ID_BEAN);
					cache.flush();
				}
			}
		} catch (final Exception e) {
			LOG.error("Exception pendant synchroniserGroupeDsi :" + structure.getClass() + ", code : " + structure.getCode() + " langue : " + structure.getLangue(), e);
		}
	}
}
