/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.tree.bean;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include = JsonSerialize.Inclusion.NON_EMPTY)
public class JsTreeNodeModel {

	private JsTreeDataModel data;

	private String state;

	private HashMap<String, String> attr;

	private HashMap<String, String> metadata;

	private List<JsTreeNodeModel> children;

	public JsTreeNodeModel() {
		children = new ArrayList<JsTreeNodeModel>();
		metadata = new HashMap<String, String>();
		attr = new HashMap<String, String>();
	}

	public JsTreeDataModel getData() {
		return data;
	}

	public void setData(JsTreeDataModel data) {
		this.data = data;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public List<JsTreeNodeModel> getChildren() {
		return children;
	}

	public void setChildren(List<JsTreeNodeModel> children) {
		this.children = children;
	}

	public HashMap<String, String> getMetadata() {
		return metadata;
	}

	public void setMetadata(HashMap<String, String> metadata) {
		this.metadata = metadata;
	}

	public HashMap<String, String> getAttr() {
		return attr;
	}

	public void setAttr(HashMap<String, String> attr) {
		this.attr = attr;
	}
}
