/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.tree.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.exception.ErreurAsyncException;
import com.jsbsoft.jtf.lang.CharEncoding;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.tree.processus.GestionJsTree;
import com.univ.tree.utils.JsTreeManager;
import com.univ.tree.utils.JsTreeUtils;
import com.univ.utils.SessionUtil;

public class JsTreeServlet extends HttpServlet {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7982996758134619952L;

	private static final Logger LOG = LoggerFactory.getLogger(JsTreeServlet.class);

	@Override
	protected void doGet(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
		final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
		if ((SessionUtil.getInfosSession(req).get(SessionUtilisateur.CODE) == null || autorisations == null)) {
			req.getRequestDispatcher("/adminsite/").forward(req, resp);
		} else {
			final GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(req.getParameter(JsTreeUtils.PARAM_BEAN_JSTREE));
			final ObjectMapper mapper = new ObjectMapper();
			mapper.setSerializationInclusion(JsonSerialize.Inclusion.NON_DEFAULT);
			final String action = req.getParameter("ACTION");
			String resultatFormatter;
			try {
				if (!StringUtils.isBlank(action)) {
					if (action.equals("RECHERCHER")) {
						resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterRechercheDepuisRequete(req).getNodes());
						resp.setContentType("application/json");
						resp.getWriter().write(resultatFormatter);
					} else if (action.equals("FILTRER")) {
						resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterFiltreDepuisRequete(req).getNodes());
						resp.setContentType("application/json");
						resp.getWriter().write(resultatFormatter);
					} else {
						resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterDepuisRequete(req).getNodes());
						resp.setContentType("application/json");
						resp.getWriter().write(resultatFormatter);
					}
				} else {
					resultatFormatter = mapper.writeValueAsString(gestionJsTree.traiterDepuisRequete(req).getNodes());
					resp.setContentType("application/json");
					resp.getWriter().write(resultatFormatter);
				}
			} catch (final ErreurAsyncException eA) {
				resp.getWriter().write(eA.getMessage());
				resp.setStatus(500);
			} catch (final Exception e) {
				LOG.error("Une erreur est survenue lors de la construction de l'arborescence", e);
			}
		}
	}

	@Override
	protected void doPost(final HttpServletRequest req, final HttpServletResponse resp) throws ServletException, IOException {
		final AutorisationBean autorisations = (AutorisationBean) SessionUtil.getInfosSession(req).get(SessionUtilisateur.AUTORISATIONS);
		if ((SessionUtil.getInfosSession(req).get(SessionUtilisateur.CODE) == null || autorisations == null)) {
			req.getRequestDispatcher("/adminsite/").forward(req, resp);
		} else {
			final GestionJsTree<?> gestionJsTree = JsTreeManager.getGestionJsTree(req.getParameter(JsTreeUtils.PARAM_BEAN_JSTREE));
			resp.setCharacterEncoding(CharEncoding.DEFAULT);
			try {
				final String result = gestionJsTree.traiterAction(autorisations, req.getParameterMap());
				resp.getWriter().write(result);
			} catch (final ErreurAsyncException e) {
				resp.getWriter().write(e.getMessage());
				resp.setStatus(500);
			}
		}
	}
}
