/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.tree.utils;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.univ.tree.processus.GestionJsTree;

public class JsTreeManager {

	/** The Constant ID_BEAN. */
	public static final String ID_BEAN = "jsTreeManager";

	/**
	 * Récupère le bean d'id passé en paramètre pour exécuter les actions de génération d'un JsTree
	 * 
	 * @param idBean
	 *            le bean à récuperer
	 * @return le bean correspondant ou null si non trouvé
	 */
	public static GestionJsTree<?> getGestionJsTree(final String idBean) {
		return (GestionJsTree<?>) ApplicationContextManager.getEveryContextBean(idBean);
	}
}
