/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.url;

/**
 * 
 * Classe servant à initialiser des Beans à utiliser dans les jsp via le tag <jsp:useBean id="t" class="<T>" scope="request" /> Il est utilisé par le produit pour initialiser un
 * maximum d'info sur le front gen.
 * 
 * @author olivier.camon
 * 
 * @param <T>
 *            le type de bean à ajouter à la request.
 */
public interface BeanFrontManager<T> {

	/**
	 * Instancie un Bean de type T qui sera ajouter en attribut à la request avant de passer par les jsp.
	 * 
	 * @return le bean qui sera utilisé en front
	 */
	T initialiseBeanFront();
}
