/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.url;

import com.univ.objetspartages.om.Metatag;

// TODO: Auto-generated Javadoc
/**
 * Classe représentant une requête de type lien de requêtes ou liste d'objets à laquelle on a associé un cache.
 */
public class UrlCacheRequest {

	private String alias = null;

	/** The code rubrique. */
	private String codeRubrique = null;

	/** The code rubrique affichage. */
	private String codeRubriqueAffichage = null;

	/** The code objet. */
	private String codeObjet = null;

	/** The code fiche. */
	private String codeFiche = null;

	/** The langue fiche. */
	private String langueFiche = null;

	/** The etat fiche. */
	private String etatFiche = null;

	/**
	 * Constructeur.
	 * 
	 * @param alias
	 * @param codeRubrique
	 *            the code rubrique
	 * @param codeRubriqueAffichage
	 *            the code rubrique affichage
	 * @param codeObjet
	 *            the code objet
	 * @param codeFiche
	 *            the code fiche
	 * @param langueFiche
	 *            the langue fiche
	 * @param etatFiche
	 *            the etat fiche
	 */
	public UrlCacheRequest(String alias, String codeRubrique, String codeRubriqueAffichage, String codeObjet, String codeFiche, String langueFiche, String etatFiche) {
		this.alias = alias;
		this.codeRubrique = codeRubrique;
		this.codeRubriqueAffichage = codeRubriqueAffichage;
		this.codeObjet = codeObjet;
		this.codeFiche = codeFiche;
		this.langueFiche = langueFiche;
		this.etatFiche = etatFiche;
	}

	public UrlCacheRequest(String alias, Metatag metatag) {
		this.alias = alias;
		this.codeRubrique = metatag.getMetaCodeRubrique();
		this.codeRubriqueAffichage = "";
		this.codeObjet = metatag.getMetaCodeObjet();
		this.codeFiche = metatag.getMetaCode();
		this.langueFiche = metatag.getMetaLangue();
		this.etatFiche = metatag.getMetaEtatObjet();
	}

	public String getKey() {
		return alias + "@" + codeRubrique + "@" + codeRubriqueAffichage + "@" + codeObjet + "@" + codeFiche + "@" + langueFiche + "@" + etatFiche;
	}

	public String getAlias() {
		return alias;
	}

	public String getCodeRubrique() {
		return codeRubrique;
	}

	public String getCodeRubriqueAffichage() {
		return codeRubriqueAffichage;
	}

	public String getCodeObjet() {
		return codeObjet;
	}

	public String getCodeFiche() {
		return codeFiche;
	}

	public String getLangueFiche() {
		return langueFiche;
	}

	public String getEtatFiche() {
		return etatFiche;
	}
}
