/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Apporte des fonctions utilitaires pour gérer les accés à la base de données.
 *
 * @author pierre.cosson
 *
 */
public abstract class AbstractBaseDonneeDao {

	private static final Logger LOG = LoggerFactory.getLogger(AbstractBaseDonneeDao.class);

	protected ContexteDao instancierContexteDao() {
		return new ContexteDao();
	}

	/**
	 * Fermer les accés ouvert pour accéder à la base de données.
	 *
	 * @param ctx
	 */
	protected void fermerAccesBD(final ContexteDao ctx) {
		fermerAccesBD(ctx, null, null);
	}

	/**
	 * Fermer les accés ouvert pour accéder à la base de données.
	 *
	 * @param ctx
	 * @param stmt
	 */
	protected void fermerAccesBD(final ContexteDao ctx, final PreparedStatement stmt) {
		fermerAccesBD(ctx, stmt, null);
	}

	/**
	 * Fermer les accés ouvert pour accéder à la base de données.
	 *
	 * @param ctx
	 * @param stmt
	 * @param res
	 */
	protected void fermerAccesBD(final ContexteDao ctx, final PreparedStatement stmt, final ResultSet res) {
		try {
			if (res != null) {
				res.close();
			}
		} catch (final Exception e) {
			LOG.debug("Erreur lors de la fermeture du resultSet", e);
		}
		try {
			if (stmt != null) {
				stmt.close();
			}
		} catch (final Exception e) {
			LOG.debug("Erreur lors de la fermeture du statement", e);
		}
		if (ctx != null) {
			ctx.close();
		}
	}
}
