/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.util.Hashtable;

import com.univ.objetspartages.om.ClassMeta;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.processus.SaisieFiche;

// TODO: Auto-generated Javadoc
/**
 * Classe d'accès aux méta-données des classes.
 */
public class ClassMetaUtil {

	/** The h class meta. */
	private static Hashtable<String, String> hClassMeta = null;

	/**
	 * Gets the objet class meta default value.
	 * 
	 * @param metaName
	 *            the meta name
	 * 
	 * @return the objet class meta default value
	 */
	private static String getObjetClassMetaDefaultValue(String metaName) {
		if (hClassMeta == null) {
			hClassMeta = new Hashtable<String, String>();
			hClassMeta.put("NOM_CODE_RATTACHEMENT", "CODE_RATTACHEMENT");
			// JSS 20051031 : rattachement secondaires
			hClassMeta.put("NOM_CODE_RATTACHEMENT_AUTRES", "CODE_RATTACHEMENT_AUTRES");
			hClassMeta.put("NOM_CODE_RUBRIQUE", "CODE_RUBRIQUE");
		}
		return hClassMeta.get(metaName);
	}

	/**
	 * Gets the processus class meta default value.
	 * 
	 * @param metaName
	 *            the meta name
	 * 
	 * @return the processus class meta default value
	 */
	private static String getProcessusClassMetaDefaultValue(String metaName) {
		if (hClassMeta == null) {
			hClassMeta = new Hashtable<String, String>();
			hClassMeta.put("NOM_CODE_RATTACHEMENT", "CODE_RATTACHEMENT");
			// JSS 20051031 : rattachement secondaires
			hClassMeta.put("NOM_CODE_RATTACHEMENT_AUTRES", "CODE_RATTACHEMENT_AUTRES");
			hClassMeta.put("NOM_CODE_RUBRIQUE", "CODE_RUBRIQUE");
		}
		return hClassMeta.get(metaName);
	}

	/**
	 * Gets the class meta value.
	 * 
	 * @param ficheUniv
	 *            the fiche univ
	 * @param metaName
	 *            the meta name
	 * 
	 * @return the class meta value
	 */
	public static String getClassMetaValue(FicheUniv ficheUniv, String metaName) {
		String value = null;
		if (ficheUniv instanceof ClassMeta) {
			value = ((ClassMeta) ficheUniv).getClassMetaValue(metaName);
		}
		if (value == null) {
			value = getObjetClassMetaDefaultValue(metaName);
		}
		return value;
	}

	/**
	 * Gets the class meta value.
	 * 
	 * @param processus
	 *            the processus
	 * @param metaName
	 *            the meta name
	 * 
	 * @return the class meta value
	 */
	public static String getClassMetaValue(SaisieFiche processus, String metaName) {
		String value = null;
		if (processus instanceof ClassMeta) {
			value = ((ClassMeta) processus).getClassMetaValue(metaName);
		}
		if (value == null) {
			value = getProcessusClassMetaDefaultValue(metaName);
		}
		return value;
	}
}
