/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import com.univ.objetspartages.om.ServiceBean;

// TODO: Auto-generated Javadoc
/**
 * Ajoute le parametrage a un service. Comportement par defaut pour k-portal.
 * 
 * @see com.univ.utils.IParametrageService
 * @author jbiard
 */
public class DefautParametrageService implements IParametrageService {

	/* (non-Javadoc)
	 * @see com.univ.utils.IParametrageService#getUrlParametree(com.univ.utils.ContexteUniv, com.univ.objetspartages.om.ServiceBean, java.lang.String, java.lang.String)
	 */
	@Override
	public String getUrlParametree(ContexteUniv ctx, ServiceBean service, String url, String ticket) {
		url += (url.indexOf("?") == -1 ? "?" : "&");
		url += "service=" + service.getCode();
		url += (url.indexOf("?") == -1 ? "?" : "&");
		url += "langue=" + ctx.getLangue();
		url += (url.indexOf("?") == -1 ? "?" : "&");
		url += "kportal_host=" + URLResolver.getAbsoluteUrl("", false, ctx.getInfosSite());
		url += (url.indexOf("?") == -1 ? "?" : "&");
		String secure = "0";
		if (URLResolver.getAbsoluteUrl("", ctx).startsWith("https")) {
			secure = "1";
		}
		url += "secure=" + secure;
		if (ticket.length() > 0) {
			url += (url.indexOf("?") == -1 ? "?" : "&");
			url += "kticket=" + ticket;
		}
		return url;
	}
}
