/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

import javax.servlet.annotation.WebServlet;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.LangueUtil;
import com.kportal.extension.module.composant.ComposantRole;

@WebServlet(name = "servletExportRoles", urlPatterns = "/servlet/downloadExportRoles", loadOnStartup = 1)
public class DownloadExportRolesServlet extends SimpleDownloadServlet {

    private static final long serialVersionUID = -2328660109979013684L;

    private static final Logger LOG = LoggerFactory.getLogger(DownloadExportRolesServlet.class);

    @Override
    protected String getFilePath() {
        return ExportCsvUtil.getExportFilePath("roles", getLocale());
    }

    @Override
    protected String getFileType() {
        return "text/csv";
    }

    // Calcul du nom de fichier proposé en téléchargement
    // Pour cet export, on formate le nom avec la date de création du fichier
    @Override
    protected String getDownloadedFileName(File file) {
        String dlFileName = super.getDownloadedFileName(file);
        try {
            BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class);
            FileTime creationTime = attributes.creationTime();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(creationTime.toMillis());
            DateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            dlFileName = "roles-" + formatter.format(calendar.getTime()) + ".csv";
        } catch (IOException e) {
            LOG.error("Erreur lors de la lecture de la date de création du fichier", e);
        }
        return dlFileName;
    }

    @Override
    protected boolean isAuthorized() {
        return ComposantRole.isAutoriseParActionProcessus(ContexteUtil.getContexteUniv().getAutorisation(), null);
    }

    private static Locale getLocale() {
        final ContexteUniv ctx = ContexteUtil.getContexteUniv();
        if (ctx != null) {
            return ctx.getLocale();
        } else {
            return LangueUtil.getDefaultLocale();
        }
    }
}
