/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.exception.ErreurApplicative;

/**
 * @author romain
 *
 */
public class ExceptionUrlObsolete extends ErreurApplicative {

	/**
	 *
	 */
	private static final long serialVersionUID = -1425973990878387689L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(ExceptionUrlObsolete.class);

	/** URL absolue de redirection */
	private String urlRedirect = "";

	public ExceptionUrlObsolete(final String _urlRedirect) {
		super("redirection permanente");
		LOG.debug("redirection vers " + _urlRedirect);
		urlRedirect = _urlRedirect;
	}

	/**
	 * @return Returns the urlRedirect.
	 */
	public String getUrlRedirect() {
		return urlRedirect;
	}
}
