/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;

import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.Locale;

public class ExportCsvUtil {

    /**
     * The Constant EXPORT_PATH_PROPERTIES_KEY.
     */
    private static final String EXPORT_PATH_PROPERTIES_KEY = "export.batch.dest";

    /**
     * The Constant EXPORT_FOLDER.
     */
    private static final String EXPORT_FOLDER = "export.folder";

    /**
     * The Constant DEFAULT_EXPORT_FOLDER.
     */
    private static final String DEFAULT_EXPORT_FOLDER = "export.default.folder";

    /**
     * The Constant EXTENSION_FILE.
     */
    private static final String EXTENSION_FILE = ".csv";

    /**
     * The Constant DEFAULT_SEPARATOR.
     */
    public static final String DEFAULT_SEPARATOR = ";";

    /**
     * The Constant ERROR.
     */
    public static final String ERROR = "error";

    public static String createNewExportFile(String exportType, Locale locale) {
        File extract = new File(getExportFilePath(exportType, locale));
        String ctm = String.valueOf(System.currentTimeMillis());
        if (extract.exists()) {
            File renamedFile = new File(getExportFilePath(exportType, locale) + "." + ctm);
            if (!extract.renameTo(renamedFile)) {
                // Si le renommage a échoué, on renvoit une erreur
                // Celle-ci est à tester à l'appel
                ctm = ERROR;
            }
        }
        return ctm;
    }

    public static boolean rollbackExportFile(String exportType, Locale locale, String lastCtm) {
        boolean succeed = false;
        File toRm = new File(getExportFilePath(exportType, locale));
        if (toRm.exists()) {
            succeed = toRm.delete();
        }
        if (succeed) {
            File toRb = new File(getExportFilePath(exportType, locale) + "." + lastCtm);
            if (toRb.exists()) {
                File renewFile = new File(getExportFilePath(exportType, locale));
                succeed = toRb.renameTo(renewFile);
            }
        }
        return succeed;
    }

    public static String getExportFilePath(String exportType, Locale locale) {
        return getFolderSpecificPath(exportType) + "/" + exportType + "_" + locale + EXTENSION_FILE;
    }

    public static String getFolderSpecificPath(String exportType) {
        String folder = StringUtils.defaultIfEmpty(exportType, DEFAULT_EXPORT_FOLDER);
        String res = getFolderAbsolutePath() + "/" + folder;
        if (StringUtils.isNotEmpty(res) && !(new File(res).exists())) {
            new File(res).mkdir();
        }
        return res;
    }

    private static String getFolderAbsolutePath() {
        String res = StringUtils.defaultIfEmpty(PropertyHelper.getCoreProperty(EXPORT_PATH_PROPERTIES_KEY), WebAppUtil.getAbsolutePath() + getFolderDefaultRelativePath());
        if (StringUtils.isNotEmpty(res) && !(new File(res).exists())) {
            new File(res).mkdir();
        }
        return res;
    }

    private static String getFolderDefaultRelativePath() {
        return PropertyHelper.getCoreProperty(EXPORT_FOLDER);
    }
}
