/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import com.jsbsoft.jtf.database.OMContext;

// TODO: Auto-generated Javadoc
/**
 * Cette interface est à utiliser pour déléguer à une source EXTERNE l'authorisation de l'utilisateur et pour synchroniser un utilisateur a une source externe.
 * 
 * @author Boutin
 */
public interface IAuthorizationExterne {

	/** The JT f_ authorizatio n_ classe. */
	public static String JTF_AUTHORIZATION_CLASSE = "authorization.externe.classe";

	/**
	 * Synchronise.
	 * 
	 * @param _login
	 *            the _login
	 * 
	 * @return true, if successful
	 */
	public boolean synchronise(String _login);

	/**
	 * Authorized.
	 * 
	 * @param _login
	 *            the _login
	 * @param _ctx
	 *            the _ctx
	 * 
	 * @return true, if successful
	 */
	public boolean authorized(String _login, OMContext _ctx);
}
