/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import com.univ.objetspartages.om.ServiceBean;

// TODO: Auto-generated Javadoc
/**
 * Enrichit l'URL du service d'un paramétrage spécifique.
 * 
 * @author jbiard
 */
public interface IParametrageService {

	/** The PARA m_ jt f_ servic e_ class e_ debut. */
	String PARAM_JTF_SERVICE_CLASSE_DEBUT = "service_parametrage";

	/** The PARA m_ jt f_ servic e_ class e_ fin. */
	String PARAM_JTF_SERVICE_CLASSE_FIN = ".classe";

	/** The PARA m_ jt f_ servic e_ classe. */
	String PARAM_JTF_SERVICE_CLASSE = PARAM_JTF_SERVICE_CLASSE_DEBUT + PARAM_JTF_SERVICE_CLASSE_FIN;

	/**
	 * Gets the url parametree.
	 * 
	 * @param ctx
	 *            the ctx
	 * @param service
	 *            the service
	 * @param url
	 *            the url
	 * @param ticket
	 *            the ticket
	 * 
	 * @return the url parametree
	 */
	String getUrlParametree(ContexteUniv ctx, ServiceBean service, String url, String ticket);
}
