/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;

import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.database.RequeteMgr;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.objetspartages.om.Media;

// TODO: Auto-generated Javadoc
/**
 * The Class LectureImageToolbox.
 *
 * @author Rom
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
/**
 * Accès front-office au fichier joint d'un objet document
 */
public class LectureImageToolbox extends HttpServlet {

	/**
	 *
	 */
	private static final long serialVersionUID = -3215356115631894058L;

	private static org.slf4j.Logger LOG = LoggerFactory.getLogger(LectureImageToolbox.class);

	/**
	 * Process incoming HTTP GET requests.
	 *
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 *
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void doGet(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException,
		java.io.IOException {
		performTask(request, response);
	}

	/**
	 * Process incoming HTTP POST requests.
	 *
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 *
	 * @throws ServletException
	 *             the servlet exception
	 * @throws IOException
	 *             Signals that an I/O exception has occurred.
	 */
	@Override
	public void doPost(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException,
		java.io.IOException {
		performTask(request, response);
	}

	/**
	 * Process incoming requests for information.
	 *
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 */
	public void performTask(final javax.servlet.http.HttpServletRequest request, final javax.servlet.http.HttpServletResponse response) {
		ContexteUniv ctx = null;
		try {
			ctx = ContexteUniv.initContexteUniv(request, response, getServletContext(), getServletConfig());
			String pathImage = "";
			boolean isLocal = false;
			final String tag = request.getParameter("TAG");
			if (tag != null && tag.length() > 0) {
				// test mise en session
				final Media media = new Media();
				final SessionUtilisateur sessionUtilisateur = (SessionUtilisateur) request.getSession(Boolean.FALSE).getAttribute(
					SessionUtilisateur.CLE_SESSION_UTILISATEUR_DANS_SESSION_HTTP);
				if (sessionUtilisateur != null) {
					final Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
					if (infosSession.get(tag) != null) {
						// récupération de l'id de l'image
						final int idxId = tag.indexOf("[id-image]");
						if (idxId != -1) {
							final int idxFinId = tag.indexOf("[/id-image]");
							String idImg = "";
							if (idxFinId != -1) {
								idImg = tag.substring(idxId + 10, idxFinId);
								if (idImg.length() > 0) {
									if (idImg.startsWith("F")) {
										idImg = idImg.substring(1);
									}
									media.init();
									media.setCtx(ctx);
									media.setIdMedia(new Long(idImg));
									media.retrieve();
									isLocal = media.isLocal();
									pathImage = media.getPathAbsolu();
								}
							}
						}
						final int lecture = (Integer) infosSession.get(tag);
						if (lecture != -1) {
							infosSession.remove(tag);
						}
					}
				}
				if (pathImage.length() > 0) {
					final ServletOutputStream writer = response.getOutputStream();
					InputStream is = null;
					boolean noAcces = false;
					try {
						if (isLocal) {
							final File f = new File(pathImage);
							is = new FileInputStream(f);
						} else {
							final URL url = new URL(pathImage);
							final URLConnection urlConnection = url.openConnection();
							is = urlConnection.getInputStream();
						}
					} catch (final Exception fnfe) {
						if (writer != null) {
							writer.close();
						}
						if (is != null) {
							is.close();
						}
						noAcces = true;
					}
					// JSS 20040222 : Gestion des identifiants de requete
					// On n'attend pas que le  document soit téléchargé
					// (détection de boucles intempestives)
					RequeteMgr.terminerRequete(ctx.getIdRequete());
					if (!noAcces) {
						final BufferedInputStream bis = new BufferedInputStream(is);
						try {
							final byte[] buf = new byte[1024 * 4];
							response.setHeader("Content-Disposition", "inline;filename=\"" + media.getSource() + "\"");
							response.setContentType(media.getFormat());
							int nbBytes;
							while ((nbBytes = bis.read(buf)) > 0) {
								writer.write(buf, 0, nbBytes);
							}
						} finally {
							if (writer != null) {
								writer.close();
							}
							if (bis != null) {
								bis.close();
							}
							if (is != null) {
								is.close();
							}
						}
					}
				}
			}
		} catch (final Exception e) {
			LOG.error("impossible de lire le fichier à renvoyer", e);
		} finally {
			ctx.release();
		}
	}
}
