/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import org.apache.commons.lang3.StringUtils;

import com.kportal.core.config.MessageHelper;

public class ParametrageHelper {

	private static String DEFAULT_PREFIX = "JOB_PARAM";

	public static String getMessage(String extensionId, String param) {
		return getMessage(DEFAULT_PREFIX, extensionId, param);
	}

	public static String getMessage(String prefix, String extensionId, String param) {
		final String key = String.format("BO.%s.%s.%s", StringUtils.upperCase(extensionId), prefix, StringUtils.upperCase(param));
		return StringUtils.defaultIfEmpty(MessageHelper.getExtensionMessage(extensionId, key), param);
	}
}
