/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import com.kportal.core.webapp.WebAppUtil;
import com.univ.objetspartages.om.SSOBean;
import com.univ.objetspartages.om.SousParagrapheBean;
import com.univ.xml.NodeUtil;

/**
 * The Class RequeteConnecteur.
 */
public class RequeteConnecteur {

	/** Logger */
	private static final Logger LOGGER = LoggerFactory.getLogger(RequeteConnecteur.class);

	/**
	 * Parsing du flux XML envoyé par le programme externe et initialisation du contexte.
	 * 
	 * @param ctx
	 *            com.univ.utils.ContexteUniv ctx pour accès à la base
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static void parseFlux(final ContexteUniv ctx) throws Exception {
		/* Données à mettre dans le contexte */
		String rubriqueExterneConnecteur = "";
		final List<SousParagrapheBean> encadresExternes = new ArrayList<SousParagrapheBean>();
		final List<String> encadresRechercheExternes = new ArrayList<String>();
		final Map<String, String> donneesSpecifiques = new HashMap<String, String>();
		String langue = "";
		/* Parsing du fichier de requête XML */
		//String ksession = ctx.getKsession();
		final String graphBean = ctx.getRequeteHTTP().getParameter("graphbean");
		LOGGER.debug("graphbean = " + graphBean);
		if (graphBean == null) {
			return;
		}
		final InputStream is = new ByteArrayInputStream(graphBean.getBytes());
		final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = null;
		Document document = null;
		Element rootElement = null;
		try {
			builder = factory.newDocumentBuilder();
			document = builder.parse(is);
			rootElement = document.getDocumentElement();
		} catch (final Exception e) {
			// Erreur lors du parsing
			// On continue normalement (pas de traitement)
		}
		Node donnees = rootElement;
		while (donnees != null) {
			if (donnees.hasChildNodes()) {
				Node requete = donnees.getFirstChild();
				while (requete != null) {
					if (requete.getNodeName().compareTo("RUBRIQUE") == 0) {
						if (requete.getFirstChild() != null) {
							rubriqueExterneConnecteur = requete.getFirstChild().getNodeValue().trim();
						}
					}
					if (requete.getNodeName().compareTo("LANGUE") == 0) {
						if (requete.getFirstChild() != null) {
							langue = requete.getFirstChild().getNodeValue().trim();
						}
					}
					if (requete.getNodeName().equals("SECURE")) {
						if (requete.getFirstChild() != null) {
							ctx.setSecure(requete.getFirstChild().getNodeValue().trim().equals("1"));
						}
					}
					if (requete.getNodeName().compareTo("LISTE_ENCADRES") == 0) {
						Node listeEncadres = requete.getFirstChild();
						while (listeEncadres != null) {
							if (listeEncadres.getNodeName().compareTo("ENCADRE") == 0) {
								final SousParagrapheBean encadre = new SousParagrapheBean();
								Node nodeEncadre = listeEncadres.getFirstChild();
								while (nodeEncadre != null) {
									if (nodeEncadre.getNodeName().compareTo("TITRE") == 0) {
										encadre.setTitre(nodeEncadre.getFirstChild().getNodeValue().trim());
									}
									if (nodeEncadre.getNodeName().compareTo("CONTENU") == 0) {
										encadre.setContenu(nodeEncadre.getFirstChild().getNodeValue().trim());
									}
									nodeEncadre = nodeEncadre.getNextSibling();
								}
								encadresExternes.add(encadre);
							}
							listeEncadres = listeEncadres.getNextSibling();
						}
					}
					if (requete.getNodeName().compareTo("DONNEES_SPECIFIQUES") == 0) {
						Node listeDonnees = requete.getFirstChild();
						while (listeDonnees != null) {
							if (listeDonnees.getNodeName().compareTo("DONNEE") == 0) {
								Node nodeDonnees = listeDonnees.getFirstChild();
								String nom = "";
								String valeur = "";
								while (nodeDonnees != null) {
									if (nodeDonnees.getNodeName().compareTo("NOM") == 0) {
										nom = nodeDonnees.getFirstChild().getNodeValue().trim();
									}
									if (nodeDonnees.getNodeName().compareTo("VALEUR") == 0) {
										valeur = nodeDonnees.getFirstChild().getNodeValue().trim();
									}
									nodeDonnees = nodeDonnees.getNextSibling();
								}
								/* Ajout de la donnée */
								if (nom.length() > 0) {
									donneesSpecifiques.put(nom, valeur);
								}
							}
							listeDonnees = listeDonnees.getNextSibling();
						}
					}
					if (requete.getNodeName().compareTo("LISTE_ENCADRES_RECHERCHE") == 0) {
						Node listeEncadresRecherche = requete.getFirstChild();
						while (listeEncadresRecherche != null) {
							if (listeEncadresRecherche.getFirstChild() != null) {
								encadresRechercheExternes.add(listeEncadresRecherche.getFirstChild().getNodeValue().trim());
							}
							listeEncadresRecherche = listeEncadresRecherche.getNextSibling();
						}
					}
					requete = requete.getNextSibling();
				}
			}
			donnees = donnees.getNextSibling();
		}
		/* Ajout des information dans le contexte */
		ctx.setRubriqueExterneConnecteur(rubriqueExterneConnecteur);
		ctx.setEncadresExternes(encadresExternes);
		ctx.setEncadresRechercheExternes(encadresRechercheExternes);
		ctx.setDonneesSpecifiques(donneesSpecifiques);
		// JSS 20050912 : ajout de la langue pour les connecteurs
		if (langue.length() > 0) {
			ctx.setLangue(langue);
		}
	}

	/**
	 * Lecture du Bean SSO à partir du fichier session.xml
	 * 
	 * @param _ksession
	 *            the _ksession
	 * 
	 * @return the SSO bean
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public static SSOBean lireBeanSSO(final String _ksession) throws Exception {
		final SSOBean ssoBean = new SSOBean();
		/** *********************************************** */
		/* Lecture du fichier XML DE SESSION */
		/** ********************************************** */
		final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		final DocumentBuilder builder = factory.newDocumentBuilder();
		Document document = null;
		final File f = new File(WebAppUtil.getSessionsPath() + File.separator + "session_" + _ksession + ".xml");
		//le fichier n'existe pas
		if (!f.exists()) {
			return ssoBean;
		}
		document = builder.parse(f);
		final Element rootElement = document.getDocumentElement();
		final Node donnees = rootElement;
		if (donnees.hasChildNodes()) {
			Node nextFeuille = donnees.getFirstChild();
			while (nextFeuille != null) {
				if (nextFeuille.getNodeName().equals("ID")) {
					ssoBean.setId(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("CODE")) {
					ssoBean.setCodeKportal(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("CIVILITE")) {
					ssoBean.setCivilite(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("NOM")) {
					ssoBean.setNom(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("PRENOM")) {
					ssoBean.setPrenom(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("EMAIL")) {
					ssoBean.setEmail(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("STRUCTURE")) {
					ssoBean.setStructure(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("CODE_LDAP")) {
					ssoBean.setCodeGestion(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("PROFIL")) {
					ssoBean.setProfil(NodeUtil.extraireValeurNode(nextFeuille));
				}
				if (nextFeuille.getNodeName().equals("GROUPES")) {
					ssoBean.setGroupes(NodeUtil.extraireValeurNode(nextFeuille));
				}
				nextFeuille = nextFeuille.getNextSibling();
			}
		}
		return ssoBean;
	}
}
