/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * Created on 10 sept. 2005
 *
 *Pseudo-reponse http pour faire des appels de service
 */
package com.univ.utils;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

// TODO: Auto-generated Javadoc
/**
 * The Class ServiceWrappedResponse.
 * 
 * @author jeanseb
 */
public class ServiceWrappedResponse extends HttpServletResponseWrapper {

	/** The writer. */
	private PrintWriter writer;

	/**
	 * Instantiates a new service wrapped response.
	 * 
	 * @param response
	 *            the response
	 * @param _writer
	 *            the _writer
	 */
	public ServiceWrappedResponse(HttpServletResponse response, PrintWriter _writer) {
		super(response);
		writer = _writer;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletResponseWrapper#getWriter()
	 */
	@Override
	public PrintWriter getWriter() throws IOException {
		return writer;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.ServletResponseWrapper#getContentType()
	 */
	@Override
	public java.lang.String getContentType() {
		return "text/html";
	}

}
