/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

import java.util.Hashtable;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import com.jsbsoft.jtf.session.SessionUtilisateur;

// TODO: Auto-generated Javadoc
/**
 * Insert the type's description here. Creation date: (10/11/2001 12:10:26)
 * 
 * @author:
 */
public class SessionUtil {

	/**
	 * Récupération des informations de session.
	 * 
	 * @param _request
	 *            the _request
	 * 
	 * @return the infos session
	 */
	public static Hashtable<String, Object> getInfosSession(final HttpServletRequest _request) {
		final HttpSession _session = _request.getSession(false);
		return getInfosSession(_session);
	}

	/**
	 * Gets the infos session.
	 * 
	 * @param _session
	 *            the _session
	 * 
	 * @return the infos session
	 */
	public static Hashtable<String, Object> getInfosSession(final HttpSession _session) {
		final SessionUtilisateur sessionUtilisateur = (SessionUtilisateur) _session.getAttribute(SessionUtilisateur.CLE_SESSION_UTILISATEUR_DANS_SESSION_HTTP);
		Hashtable<String, Object> infos = null;
		if (sessionUtilisateur != null) {
			infos = sessionUtilisateur.getInfos();
		} else {
			infos = new Hashtable<String, Object>();
		}
		return infos;
	}

	/**
	 * Détermine si l'utilisateur est connecté.
	 * 
	 * @param sessionUtilisateur
	 *            the session utilisateur
	 * 
	 * @return true, if est connecte
	 */
	public static boolean estConnecte(final SessionUtilisateur sessionUtilisateur) {
		boolean res = false;
		if (sessionUtilisateur != null) {
			final Object o = sessionUtilisateur.getInfos().get(SessionUtilisateur.AUTORISATIONS);
			if (o != null) {
				res = true;
			}
		}
		return res;
	}
}
