/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils;

public enum TableauBordAttribute {

    LIBELLE_FICHE(IRequeteurConstantes.ATTRIBUT_LIBELLE_FICHE),
    CODE_OBJET(IRequeteurConstantes.ATTRIBUT_CODE_OBJET),
    DATE_FIN(IRequeteurConstantes.ATTRIBUT_DATE_FIN),
    CODE_REDACTEUR(IRequeteurConstantes.ATTRIBUT_CODE_REDACTEUR),
    TYPE_DATE(IRequeteurConstantes.ATTRIBUT_TYPE_DATE),
    LANGUE_FICHE(IRequeteurConstantes.ATTRIBUT_LANGUE),
    DIFFUSION_PUBLIC_VISE(IRequeteurConstantes.ATTRIBUT_DIFFUSION_PUBLIC_VISE),
    CODE_RUBRIQUE(IRequeteurConstantes.ATTRIBUT_CODE_RUBRIQUE),
    DATE_DEBUT(IRequeteurConstantes.ATTRIBUT_DATE_DEBUT),
    CODE_RATTACHEMENT(IRequeteurConstantes.ATTRIBUT_CODE_RATTACHEMENT),
    ETAT_OBJET(IRequeteurConstantes.ATTRIBUT_ETAT_OBJET);

    private String value;

    TableauBordAttribute(String value){
        this.value = value;
    }

    public String getRequeteParam(){
        return this.value + "_REQ";
    }

    public String getTriParam(){
        return this.value + "_TRI";
    }

    public String getValue() {
        return value;
    }
}