/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.cache;

import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import com.univ.utils.ContexteUtil;
import com.univ.utils.RequeteUtil;

/**
 * Classe représentant une requête de type lien de requêtes ou liste d'objets à laquelle on a associé un cache.
 */
public class ObjetsCacheRequest implements ICacheRequest {

	public static final String ID_BEAN = "objetsCacheRequest";

	/**
	 * Exécute la requête.
	 * 
	 * @return the object
	 * 
	 * @throws Exception
	 *             On fait suivre l'exception de RequeteUtil (pas de mise en cache dans ce cas)
	 */
	@Override
	@TempCacheGet(key = "ObjetsCacheRequest.cache", contextual = false, numberOfParameterForKeyGeneration = 2)
	public Object call(String kSession, String key, Object... objects) throws Exception {
		return perform(objects);
	}

	@Override
	@TempCacheFlush(key = "ObjetsCacheRequest.cache", contextual = false)
	public void flush() throws Exception {}

	@Override
	public Object perform(Object... objects) throws Exception {
		return RequeteUtil.traiterRequete(ContexteUtil.getContexteUniv(), (String) objects[0]);
	}

	@Override
	public String getKey(Object... objects) {
		return (String) objects[0];
	}
}
