/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.cache;

import java.util.TreeMap;

import com.kdecole.cache.aspect.TempCacheFlush;
import com.kdecole.cache.aspect.TempCacheGet;
import com.univ.utils.AbstractRequeteur;
import com.univ.utils.IRequeteurConstantes;

/**
 * The Class RequeteurFicheCacheRequest.
 */
public class RequeteurFicheCacheRequest implements ICacheRequest {

	public static final String ID_BEAN = "requeteurFicheCacheRequest";

	@Override
	@TempCacheGet(key = "RequeteurFicheCacheRequest.cache", contextual = false, numberOfParameterForKeyGeneration = 2)
	public Object call(final String kSession, final String key, final Object... objects) throws Exception {
		return perform(objects);
	}

	/**
	 * Gets the liste fiches.
	 * 
	 * @return the liste fiches
	 * 
	 * @throws Exception
	 *             the exception
	 */
	public TreeMap<String, Object> getListeFiches(final AbstractRequeteur requeteur, final String codeTri, final String ordreTri, final int from, final int increment,
		final String count) throws Exception {
		TreeMap<String, Object> listeFiches = new TreeMap<>();
		String idMeta;
		int compteur;
		try {
			final TreeMap<String, Object> resultCache = requeteur.getListeFiches(codeTri, ordreTri, from, increment, count);
			/*
			 * Tableaux de bords au comportement standard cad qu'on retrieve
			 * tous les fiches renvoyés par le select
			 */
			if (count.equals(IRequeteurConstantes.REQUETE_COUNT)) {
				// en mode count, le resultat ne renvoie qu'un élément, on
				// renvoie la liste telle quelle
				// !il peut y avoir un diff avec le nb de fiches réelles
				listeFiches = resultCache;
			} else {
				compteur = IRequeteurConstantes.NB_RESULTAT + 1;
				for (final String string : resultCache.keySet()) {
					idMeta = string;
					// on traite les éléments (sf si c'est le nombre de resultat)
					if (!idMeta.equals("" + IRequeteurConstantes.NB_RESULTAT)) {
						// Récupération ds infos fiches
						listeFiches.put("" + compteur, resultCache.get(idMeta));
						compteur++;
					}
				}
				if (count.equals(IRequeteurConstantes.REQUETE_AVEC_COUNT)) {
					listeFiches.put("" + IRequeteurConstantes.NB_RESULTAT, resultCache.get("" + IRequeteurConstantes.NB_RESULTAT));
				}
			}
		} catch (final Exception e) {
		}
		return listeFiches;
	}

	@Override
	@TempCacheFlush(key = "RequeteurFicheCacheRequest.cache", contextual = false)
	public void flush() throws Exception {}

	@Override
	public Object perform(final Object... objects) throws Exception {
		return getListeFiches((AbstractRequeteur) objects[0], (String) objects[1], (String) objects[2], (int) objects[3], (int) objects[4], (String) objects[5]);
	}

	@Override
	public String getKey(final Object... objects) {
		return ((AbstractRequeteur) objects[0]).genererUrlRequete();
	}
}
