/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.univ.utils.ContexteUtil;

/**
 * 
 * Ce filtre sert uniquement à initialiser un Contexte pouvant être récupérer facilement dans le thread courant. Il se charge de l'initialisation et du release du contexte.
 * 
 * @author olivier.camon
 * 
 */
public class ContexteFilter implements Filter {

	private FilterConfig config;

	@Override
	public void destroy() {}

	@Override
	public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
		ContexteUtil.setContexteUniv((HttpServletRequest) request, (HttpServletResponse) response, config.getServletContext());
		try {
			chain.doFilter(request, response);
		} finally {
			ContexteUtil.releaseContexteUniv();
		}
	}

	@Override
	public void init(final FilterConfig config) throws ServletException {
		this.config = config;
	}
}
