/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;

public class ForwardContexteFilter implements Filter {

	private static final Logger LOG = LoggerFactory.getLogger(ForwardContexteFilter.class);

	@Override
	public void destroy() {}

	/**
	 * Dans le contexte on stocke 40K truc, or sur les forward, il faut mettre à jour des paramètres qui changent comme la requête http, le code de rubrique etc etc.
	 */
	@Override
	public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
		final ContexteUniv ctx = ContexteUtil.getContexteUniv();
		final HttpServletRequest requeteHttp = (HttpServletRequest) request;
		if (ctx != null && !requeteHttp.equals(ctx.getRequeteHTTP())) {
			ctx.setRequeteHTTP(requeteHttp);
			gestionParametreRH(ctx);
			rechargeInfosSessionsUtilisateurs(ctx);
		}
		chain.doFilter(request, response);
	}

	/**
	 * Si l'utilisateur est connecté mais qu'on a pas encore ses autorisations (après une connexion par exemple) on recharge ses infos dans le contexte. Si il est connecté, on
	 * récupère les infos sur l'espace collab
	 * 
	 * @param ctx
	 */
	private void rechargeInfosSessionsUtilisateurs(final ContexteUniv ctx) {
		final HttpServletRequest requeteHttp = ctx.getRequeteHTTP();
		try {
			final HttpSession sessionHTTP = requeteHttp.getSession(Boolean.FALSE);
			if (sessionHTTP != null) {
				final SessionUtilisateur sessionUtilisateur = (SessionUtilisateur) sessionHTTP.getAttribute(SessionUtilisateur.CLE_SESSION_UTILISATEUR_DANS_SESSION_HTTP);
				if (sessionUtilisateur != null) {
					if (ctx.getAutorisation() == null) {
						ctx.initialiserInfosUtilisateur();
					} else {
						ctx.initialiserEspace();
					}
				}
			}
		} catch (final Exception e) {
			LOG.error("erreur sur l'initialisation des infos utilisateur", e);
		}
	}

	/**
	 * On récupère le parametre RH depuis la requete ou depuis l'infobean si il existe.
	 * 
	 * @param ctx
	 * @param requeteHttp
	 */
	private void gestionParametreRH(final ContexteUniv ctx) {
		final HttpServletRequest requeteHttp = ctx.getRequeteHTTP();
		String codeRH = requeteHttp.getParameter("RH");
		if (StringUtils.isBlank(codeRH)) {
			final InfoBean infoBean = (InfoBean) requeteHttp.getAttribute("infoBean");
			if (infoBean != null) {
				codeRH = infoBean.getString("RH");
			}
		}
		if (StringUtils.isNotBlank(codeRH)) {
			ctx.setCodeRubriqueHistorique(codeRH);
		}
	}

	@Override
	public void init(final FilterConfig arg0) throws ServletException {}
}
