/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.json;


import org.apache.commons.lang3.StringUtils;

public class NamingStrategyHelper {

	public static String translateUppercaseToUnderscore(String defaultName) {
		char[] nameChars = StringUtils.uncapitalize(defaultName).toCharArray();
		StringBuilder nameTranslated = new StringBuilder(nameChars.length * 2);
		for (char c : nameChars) {
			if (Character.isUpperCase(c)) {
				nameTranslated.append("_");
				c = Character.toLowerCase(c);
			}
			nameTranslated.append(c);
		}
		return nameTranslated.toString();
	}

	public static String translateUnderscoreToUppercase(String defaultName) {
		final char[] nameChars = defaultName.toCharArray();
		final StringBuilder nameTranslated = new StringBuilder(nameChars.length * 2);
		boolean wasUnderscore = false;
		for (char c : nameChars) {
			if(c == '_') {
				wasUnderscore = true;
			} else if(wasUnderscore) {
				nameTranslated.append(Character.toUpperCase(c));
				wasUnderscore = false;
			} else {
				nameTranslated.append(c);
			}
		}
		return nameTranslated.toString();
	}
}
