/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.media;

import java.util.HashMap;
import java.util.Map;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.exception.ErreurTechnique;
import com.univ.mediatheque.Mediatheque;
import com.univ.objetspartages.om.Libelle;
import com.univ.objetspartages.om.SpecificMedia;

/**
 * Helper permettant de générer des couples de codes et libellé sur les type de ressources / type de médias des médias.
 * 
 * @author aga
 * 
 */
public class TypeRessourceTypeMediaHelper {

	/**
	 * Nom du bean tel que défini dans le contexte Spring
	 */
	public final static String ID_BEAN = "typeRessourceTypeMediaHelper";

	/**
	 * Une instance de l'objet mediatheque
	 */
	private Mediatheque mediatheque;

	/**
	 * Pour tous les types de media du type de ressource dont le code est en paramètre retourne une map<String,String> dont la clé est la concaténation du code du type de ressource
	 * et du code du type de media (suivant {@link CodeTypeRessourceCodeTypeMedia#toString()} et la valeur est la concaténation du libellé du type de ressource et du libellé du
	 * type de media (suivant {@link LibelleTypeRessourceLibelleTypeMedia#toString()} Une entrée est également ajoutés pour chaque type de ressource pour représenter le choix
	 * "tous les médias du type de ressource".
	 * 
	 * La principale utilité de cette méthode est de faciliter la génération d'un filtre unique sur les types de médias de tous les types de ressources (pour la gallerie notament).
	 * 
	 * @param ctx
	 *            Le contexte kportal
	 * @param codeTypeRessource
	 *            Le code du type de la ressource pour lequel on veut générer la map
	 * @return Une map<String,String>
	 * @throws ErreurTechnique
	 */
	public Map<String, String> getCodeEtLibelleTypeRessourceEtTypeMedia(OMContext ctx, String codeTypeRessource) throws ErreurTechnique {
		Map<String, String> result = new HashMap<>();
		SpecificMedia specificMedia = getMediatheque().getRessource(codeTypeRessource);
		Map<String, String> codesEtLibellesMedia;
		try {
			codesEtLibellesMedia = Libelle.getListe(specificMedia.getCodeTypeLibelle(), LangueUtil.getDefaultLocale());
		} catch (Exception e) {
			throw new ErreurTechnique(ErreurTechnique.TYPERR_SGBD, "Erreur pendant l'accès aux libellés", e);
		}
		//ajout d'une entrée pour debut optgroupe de ce type de média
		//result.put(StringUtils.chop(codeTypeRessource), "#GROUPE#" + specificMedia.getLibelleAffichable());
		//ajout d'une entrée pour "toutes les ressources de ce type de média"
		result.put(new CodeTypeRessourceCodeTypeMedia(codeTypeRessource, null).toString(),
				new LibelleTypeRessourceLibelleTypeMedia(specificMedia.getLibelleAffichable(), null).toString());
		if (codesEtLibellesMedia != null) {
			for (Map.Entry<String, String> codeEtLibelleMediaEntry : codesEtLibellesMedia.entrySet()) {
				result.put(new CodeTypeRessourceCodeTypeMedia(codeTypeRessource, codeEtLibelleMediaEntry.getKey()).toString(), new LibelleTypeRessourceLibelleTypeMedia(
						specificMedia.getLibelleAffichable(), codeEtLibelleMediaEntry.getValue()).toString());
			}
		}
		//ajout d'une entrée pour fin optgroupe de ce type de média
		//result.put(codeTypeRessource + "|z", "#/GROUPE#" + specificMedia.getLibelleAffichable());
		return result;
	}

	/**
	 * @return the mediatheque
	 */
	public Mediatheque getMediatheque() {
		return mediatheque;
	}

	/**
	 * @param mediatheque
	 *            the mediatheque to set
	 */
	public void setMediatheque(Mediatheque mediatheque) {
		this.mediatheque = mediatheque;
	}
}
