/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.recherche;

import java.util.ArrayList;
import java.util.Collection;

import com.univ.objetspartages.om.Metatag;

/**
 * Encapsule les résultats d'une recherche multifiche
 * 
 */
public class ResultatRechercheMultifiche {

	/**
	 * Le code objet partagé par tous les résultats
	 */
	private String codeObjet;

	/**
	 * La liste de Metatag décrivant les fiches faisant parti des résultats
	 */
	private Collection<Metatag> resultats = new ArrayList<Metatag>();

	/**
	 * @return the codeObjet
	 */
	public String getCodeObjet() {
		return codeObjet;
	}

	/**
	 * @param codeObjet
	 *            the codeObjet to set
	 */
	public void setCodeObjet(String codeObjet) {
		this.codeObjet = codeObjet;
	}

	/**
	 * @return the resultats
	 */
	public Collection<Metatag> getResultats() {
		return resultats;
	}

	/**
	 * @param resultats
	 *            the resultats to set
	 */
	public void setResultats(Collection<Metatag> resultats) {
		this.resultats = resultats;
	}
}
