/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.clause;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.EscapeString;
import com.univ.utils.sql.ConstanteSQL;

/**
 * Représente une clause GROUP BY d'une requête SQL. une clause Group By contient un ensemble de nom de champ. Exemple : GROUP BY FOO, BAR
 * 
 * @author olivier.camon
 * 
 */
public class ClauseGroupBy implements ClauseSQL {

	public List<String> groupBy;

	public ClauseGroupBy() {
		groupBy = new ArrayList<String>();
	}

	/**
	 * Ajoute une règle de regroupement à la clause.
	 * 
	 * @param nomChamp
	 *            le champ que l'on souhaite ajouter au group by
	 * @return l'instance courante de la clause group by
	 */
	public ClauseGroupBy groupBy(String nomChamp) {
		groupBy.add(nomChamp);
		return this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.univ.utils.sql.clause.ClauseSQL#formaterSQL()
	 */
	@Override
	public String formaterSQL() {
		StringBuilder groupByFormater = new StringBuilder();
		boolean isFirst = Boolean.TRUE;
		for (String valeurGroupBy : groupBy) {
			if (!isFirst) {
				groupByFormater.append(" , ");
			}
			groupByFormater.append(EscapeString.escapeSql(valeurGroupBy));
			isFirst = Boolean.FALSE;
		}
		groupByFormater = ajouterClauseGroupBySiNonVide(groupByFormater);
		return groupByFormater.toString();
	}

	private StringBuilder ajouterClauseGroupBySiNonVide(StringBuilder requeteSQLFormater) {
		if (StringUtils.isNotEmpty(requeteSQLFormater.toString())) {
			requeteSQLFormater.insert(0, ConstanteSQL.GROUP_BY);
		}
		return requeteSQLFormater;
	}
}
