/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/** Package contenant Les outils pour construire des conditions en SQL.
 */
package com.univ.utils.sql.condition;

/**
 * Répresente une condition SQL. Elle peut être simple : X = Y Ou Multiple (A = B AND C = D )
 * 
 * @author olivier.camon
 * 
 */
public interface Condition {

	/**
	 * Formatte les valeurs de la condition pour sortir une requête SQL.
	 * 
	 * @return la condition formatter au language SQL
	 */
	String formaterCondition();

	/**
	 * Vérifie que la condition n'est pas vide ou nulle.
	 * 
	 * @return vrai si la condition est vide ou nulle
	 */
	boolean isEmpty();
}
