/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.condition;

import org.apache.commons.lang3.StringUtils;

import com.univ.utils.sql.Operateur;
import com.univ.utils.sql.operande.Operande;

public class ConditionSimple implements Condition {

	private Operande premiereOperande;

	private Operateur operateur;

	private Operande deuxiemeOperande;

	private static final String VALEUR_RETOUR_SI_VIDE = "";

	public ConditionSimple() {
		super();
	}

	public ConditionSimple(Operande premiereOperande, Operateur operateur, Operande deuxiemeOperande) {
		setPremiereOperande(premiereOperande);
		setOperateur(operateur);
		setDeuxiemeOperande(deuxiemeOperande);
	}

	public Operande getPremiereOperande() {
		return premiereOperande;
	}

	public void setPremiereOperande(Operande premiereOperande) {
		this.premiereOperande = premiereOperande;
	}

	public Operateur getOperateur() {
		return operateur;
	}

	public void setOperateur(Operateur operateur) {
		this.operateur = operateur;
	}

	public Operande getDeuxiemeOperande() {
		return deuxiemeOperande;
	}

	public void setDeuxiemeOperande(Operande deuxiemeOperande) {
		this.deuxiemeOperande = deuxiemeOperande;
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.condition.Condition#formaterCondition()
	 */
	@Override
	public String formaterCondition() {
		if (isAttributNull()) {
			return VALEUR_RETOUR_SI_VIDE;
		}
		String formatPremiereOperande = premiereOperande.formaterOperande();
		String formatDeuxiemeOperande = deuxiemeOperande.formaterOperande();
		if (StringUtils.isEmpty(formatPremiereOperande) || StringUtils.isEmpty(formatDeuxiemeOperande)) {
			return VALEUR_RETOUR_SI_VIDE;
		}
		return premiereOperande.formaterOperande() + operateur.getOperateur() + deuxiemeOperande.formaterOperande();
	}

	private Boolean isAttributNull() {
		return (premiereOperande == null || deuxiemeOperande == null || operateur == null);
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.condition.Condition#isEmpty()
	 */
	@Override
	public boolean isEmpty() {
		return StringUtils.isEmpty(formaterCondition());
	}
}
