/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.criterespecifique;

import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.sql.clause.ClauseJoin;
import com.univ.utils.sql.clause.ClauseJoin.TypeJointure;
import com.univ.utils.sql.condition.Condition;
import com.univ.utils.sql.operande.TypeOperande;

public class ClauseJoinHelper {

	/**
	 * Permet de créer une jointure de type LEFT JOIN sur la table METATAG à partir d'une fiche passé en paramètre
	 *
	 * @param fiche
	 *            permet de connaitre le nom de la classe de l'objet ficheUniv, ne doit pas être null
	 * @return
	 */
	public static ClauseJoin creerJointureMetaTag(final FicheUniv fiche) {
		ClauseJoin joinMetaDonnee = new ClauseJoin(TypeJointure.LEFT_JOIN, "METATAG META");
		final String codeObjet = ReferentielObjets.getCodeObjet(fiche);
		final String nomClasse = ReferentielObjets.getNomTableSql(codeObjet);
		joinMetaDonnee = creerJointure(TypeJointure.LEFT_JOIN, "METATAG META", ConditionHelper.critereJointureSimple("T1.ID_" + nomClasse, "META.META_ID_FICHE"));
		joinMetaDonnee.and(ConditionHelper.egalVarchar("META.META_CODE_OBJET", codeObjet));
		return joinMetaDonnee;
	}

	/**
	 * Permet de créer une jointure de type LEFT JOIN sur la table RUBRIQUEPUBLICATION à partir d'une fiche passé en paramètre
	 *
	 * @param fiche
	 *            permet de connaitre le code de l'objet, ne doit pas être null
	 * @return
	 */
	public static ClauseJoin creerJointureRubPub(final FicheUniv fiche) {
		final ClauseJoin joinRubPub = new ClauseJoin(TypeJointure.LEFT_JOIN, "RUBRIQUEPUBLICATION RUB_PUB");
		final String codeObjet = ReferentielObjets.getCodeObjet(fiche);
		joinRubPub.on(ConditionHelper.critereJointureSimple("T1.CODE", "RUB_PUB.CODE_FICHE_ORIG"));
		joinRubPub.and(ConditionHelper.egal("T1.LANGUE", "RUB_PUB.LANGUE_FICHE_ORIG", TypeOperande.NOM_CHAMP));
		joinRubPub.and(ConditionHelper.egalVarchar("RUB_PUB.TYPE_FICHE_ORIG", codeObjet));
		return joinRubPub;
	}

	/**
	 * Creer une jointure basique en fonction du type de jointure fourni du nom de la table et de la condition fourni
	 *
	 * @param type
	 * @param nomTableEtAlias
	 * @param conditionDeJointure
	 * @return
	 */
	public static ClauseJoin creerJointure(final TypeJointure type, final String nomTableEtAlias, final Condition conditionDeJointure) {
		final ClauseJoin jointure = new ClauseJoin(type, nomTableEtAlias);
		jointure.on(conditionDeJointure);
		return jointure;
	}
}
