/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.criterespecifique;

import org.apache.commons.lang3.StringUtils;

import com.jsbsoft.jtf.database.OMContext;
import com.univ.utils.sql.clause.ClauseLimit;

/**
 * Classe utilitaire calculant les critères limit d'une requête SQL
 * 
 * @author olivier.camon
 * 
 */
public class LimitHelper {

	/**
	 * Migration de la méthode SQLUtil.ajouterCriteresLimitesEtOptimisation(String, OMContext, String)}
	 * 
	 * @param ctx
	 * @param limit
	 * @return
	 */
	public static ClauseLimit ajouterCriteresLimitesEtOptimisation(OMContext ctx, final String limit) {
		ClauseLimit limite = new ClauseLimit(0);
		if (StringUtils.isNotEmpty(limit) && StringUtils.isNumeric(limit)) {
			int nbLignes = Integer.parseInt(limit);
			if (ctx.getDatas().get("optimizedSelect") != null) {
				ctx.getDatas().put("optimizedLimit", limit);
			} else {
				limite.setNbLignes(nbLignes);
			}
		}
		ctx.getDatas().put("optimizedObject", "true");
		return limite;
	}

	public static ClauseLimit ajouterCriteresLimitesEtOptimisation(OMContext ctx, final int offset, final int limit) {
		ClauseLimit limite = new ClauseLimit(0);
		if (limit > 0) {
			if (ctx.getDatas().get("optimizedSelect") != null) {
				ctx.getDatas().put("optimizedLimit", String.valueOf(limit));
			} else {
				limite.setNbLignes(limit);
				limite.setOffset(offset);
			}
		}
		return limite;
	}
}
