/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.operande;

import java.util.Collection;

import com.univ.utils.EscapeString;
import com.univ.utils.sql.ConstanteSQL;

/**
 * Opérande permettant d'inserer une liste de valeur tel que lors de l'utilisation d'une condition IN
 * 
 * @author olivier.camon
 * 
 */
public class ListeVarchar implements Operande {

	private Collection<String> valeurs;

	public ListeVarchar(Collection<String> valeurs) {
		this.valeurs = valeurs;
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.operande.Operande#formaterOperande()
	 */
	@Override
	public String formaterOperande() {
		if (valeurs == null || valeurs.isEmpty()) {
			return "";
		}
		StringBuilder listeDeValeursFormatter = new StringBuilder(ConstanteSQL.PARENTHESE_OUVRANTE);
		Boolean isFirst = Boolean.TRUE;
		for (String valeur : valeurs) {
			if (!isFirst) {
				listeDeValeursFormatter.append(", ");
			}
			listeDeValeursFormatter.append("'").append(EscapeString.escapeSql(valeur)).append("'");
			isFirst = Boolean.FALSE;
		}
		listeDeValeursFormatter.append(ConstanteSQL.PARENTHESE_FERMANTE);
		return listeDeValeursFormatter.toString();
	}
}
