/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.operande;

import com.univ.utils.EscapeString;

/**
 * Permet d'inserer un nom de champ dans la requête tel que T1.CODE = ...
 * 
 * @author olivier.camon
 * 
 */
public class NomChamp implements Operande {

	private String valeurnomChamp;

	public NomChamp(String nomChamp) {
		this.valeurnomChamp = nomChamp;
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.operande.Operande#formaterOperande()
	 */
	@Override
	public String formaterOperande() {
		if (valeurnomChamp == null) {
			return "";
		}
		return EscapeString.escapeSql(valeurnomChamp);
	}
}
