/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.operande;

/**
 * Opérande non échappable utile pour utilier des fonctions tel que REGEXP ou DATE(...) cet opérande n'est pas échappé, il faut que l'utilisateur ÉCHAPE ABSOLUMENT SA VALEUR LUI
 * MÊME lors de l'utilisation de cet opérande
 * 
 * @author olivier.camon
 * 
 */
public class NonEchapable implements Operande {

	private Object valeurNonEchapable;

	public NonEchapable(String valeur) {
		this.valeurNonEchapable = valeur;
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.operande.Operande#formaterOperande()
	 */
	@Override
	public String formaterOperande() {
		if (valeurNonEchapable == null) {
			return "";
		}
		return valeurNonEchapable.toString();
	}
}
