/**
 * Copyright (C) 2015 - 2018 Kosmos contact@kosmos.fr
 *
 * Projet: core
 * Version: 6.02.48
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.univ.utils.sql.operande;

import java.sql.Date;
import java.text.SimpleDateFormat;

import com.univ.utils.EscapeString;

/**
 * Permet de formatter un champ contenant une date de type java.sql.date la date est formatter soit en "yyyy-MM-dd" soit en "yyyy-MM-dd HH:mm:ss" en fonction des besoins
 * 
 * @author olivier.camon
 * 
 */
public class OperandeDate implements Operande {

	private Date valeur;

	private boolean isDateEtHeure;

	public OperandeDate(Date valeur, boolean isDateEtHeure) {
		this.valeur = valeur;
		this.isDateEtHeure = isDateEtHeure;
	}

	/*
	 * (non-Javadoc)
	 * @see com.univ.utils.sql.operande.Operande#formaterOperande()
	 */
	@Override
	public String formaterOperande() {
		if (valeur == null) {
			return "";
		}
		String dateFormate = "";
		if (isDateEtHeure) {
			dateFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(valeur);
		} else {
			dateFormate = new SimpleDateFormat("yyyy-MM-dd").format(valeur);
		}
		return "'" + EscapeString.escapeSql(dateFormate) + "'";
	}
}
